/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.main;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import pl.smartapps.hm.WebViewer.shared.model.Transaction;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.UserEntity;

@Entity
@Table(name="transaction")
public class TransactionEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="transaction_seq")
    @SequenceGenerator(name="transaction_seq", sequenceName="transaction_seq", allocationSize=1)
    @Basic(optional=false)
    @Column(name="transaction_id")
    private Integer transactionId;
    @Basic(optional=false)
    @Column(name="timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date timestamp;
    @Basic(optional=false)
    @Column(name="currency")
    private String currency;
    @Basic(optional=false)
    @Column(name="amount")
    private BigDecimal amount;
    @Column(name="reference_nr")
    private String referenceNr;
    @Column(name="status")
    private String status;
    @Column(name="valid_to")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date validTo;
    @JoinColumn(name="user_id", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private UserEntity user;
    @JoinColumn(name="landevice_id", referencedColumnName="landevice_id")
    @ManyToOne
    private LanDeviceEntity lanDevice;
    @Column(name="raw_response")
    private String rawResponse;
    @Basic(optional=false)
    @Column(name="gateway")
    private String gateway;
    @Column(name="payment_type")
    String paymentType;

    public TransactionEntity() {
    }

    public TransactionEntity(Integer transactionId) {
        this.transactionId = transactionId;
    }

    public TransactionEntity(Integer transactionId, Date timestamp, String currency, BigDecimal amount, String referenceNr, String status, String gateway) {
        this.transactionId = transactionId;
        this.timestamp = timestamp;
        this.currency = currency;
        this.amount = amount;
        this.referenceNr = referenceNr;
        this.status = status;
        this.gateway = gateway;
    }

    public Integer getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(Integer transactionId) {
        this.transactionId = transactionId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getReferenceNr() {
        return this.referenceNr;
    }

    public void setReferenceNr(String referenceNr) {
        this.referenceNr = referenceNr;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public void setValidTo(Date validTo) {
        this.validTo = validTo;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public LanDeviceEntity getLanDevice() {
        return this.lanDevice;
    }

    public void setLanDevice(LanDeviceEntity lanDevice) {
        this.lanDevice = lanDevice;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public void setRawResponse(String rawResponse) {
        this.rawResponse = rawResponse;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        result = 31 * result + (this.currency == null ? 0 : this.currency.hashCode());
        result = 31 * result + (this.lanDevice == null ? 0 : this.lanDevice.hashCode());
        result = 31 * result + (this.referenceNr == null ? 0 : this.referenceNr.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.transactionId == null ? 0 : this.transactionId.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.validTo == null ? 0 : this.validTo.hashCode());
        result = 31 * result + (this.rawResponse == null ? 0 : this.rawResponse.hashCode());
        result = 31 * result + (this.gateway == null ? 0 : this.gateway.hashCode());
        result = 31 * result + (this.paymentType == null ? 0 : this.paymentType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionEntity other = (TransactionEntity)obj;
        if (this.amount == null ? other.amount != null : !this.amount.equals(other.amount)) {
            return false;
        }
        if (this.currency == null ? other.currency != null : !this.currency.equals(other.currency)) {
            return false;
        }
        if (this.lanDevice == null ? other.lanDevice != null : !this.lanDevice.equals((Object)other.lanDevice)) {
            return false;
        }
        if (this.referenceNr == null ? other.referenceNr != null : !this.referenceNr.equals(other.referenceNr)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        if (this.transactionId == null ? other.transactionId != null : !this.transactionId.equals(other.transactionId)) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals((Object)other.user)) {
            return false;
        }
        if (this.validTo == null ? other.validTo != null : !this.validTo.equals(other.validTo)) {
            return false;
        }
        if (this.rawResponse == null ? other.rawResponse != null : !this.rawResponse.equals(other.rawResponse)) {
            return false;
        }
        if (this.gateway == null ? other.gateway != null : !this.gateway.equals(other.gateway)) {
            return false;
        }
        return !(this.paymentType == null ? other.paymentType != null : !this.paymentType.equals(other.paymentType));
    }

    public String toString() {
        return "Transaction [transactionId=" + this.transactionId + "]";
    }

    public String dump() {
        return "Transaction [transactionId=" + this.transactionId + ", timestamp=" + this.timestamp + ", currency=" + this.currency + ", amount=" + this.amount + ", referenceNr=" + this.referenceNr + ", status=" + this.status + ", validTo=" + this.validTo + ", user=" + this.user + ", lanDevice=" + this.lanDevice + ", gateway=" + this.gateway + ", paymentType=" + this.paymentType + "]";
    }

    public Transaction toDto() {
        Transaction dto = new Transaction();
        dto.setTransactionId(this.transactionId);
        dto.setTimestamp(this.timestamp);
        dto.setCurrency(this.currency);
        dto.setAmount(this.amount);
        dto.setStatus(this.status);
        dto.setReferenceNr(this.referenceNr);
        dto.setValidTo(this.validTo);
        dto.setUser(this.user.toDTO());
        dto.setLanDevice(this.lanDevice.toDTO(null, null, false, false, false, null, null));
        dto.setRawResponse(this.rawResponse);
        dto.setGateway(this.gateway);
        dto.setPaymentType(this.paymentType);
        return dto;
    }
}

