/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.main;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.Product;
import pl.smartapps.restserver.db.main.ProductfeatureEntity;

@Entity
@Table(name="product")
public class ProductEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="product_seq")
    @SequenceGenerator(name="product_seq", sequenceName="product_seq", allocationSize=1)
    @Basic(optional=false)
    @Column(name="product_id")
    private Integer productId;
    @Basic(optional=false)
    @Column(name="name")
    private String name;
    @Basic(optional=false)
    @Column(name="valid_from")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date validFrom;
    @Basic(optional=false)
    @Column(name="valid_to")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date validTo;
    @Basic(optional=false)
    @Column(name="code")
    private String code;
    @OneToMany(mappedBy="product", fetch=FetchType.EAGER)
    private Set<ProductfeatureEntity> productfeatures;

    public ProductEntity() {
    }

    public ProductEntity(Integer productId) {
        this.productId = productId;
    }

    public ProductEntity(Integer productId, String name, Date validFrom, Date validTo) {
        this.productId = productId;
        this.name = name;
        this.validFrom = validFrom;
        this.validTo = validTo;
    }

    public Integer getProductId() {
        return this.productId;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public void setValidTo(Date validTo) {
        this.validTo = validTo;
    }

    public Set<ProductfeatureEntity> getProductfeatures() {
        return this.productfeatures;
    }

    public void setProductfeatures(Set<ProductfeatureEntity> productfeatures) {
        this.productfeatures = productfeatures;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ProductfeatureEntity getProductFeature(DeviceFeatureCode code) {
        if (code == null) {
            return null;
        }
        for (ProductfeatureEntity productfeature : this.productfeatures) {
            if (!productfeature.getFeature().getFeatureCode().equals(code.name())) continue;
            return productfeature;
        }
        return null;
    }

    public String getProductFeatureValue(DeviceFeatureCode code) {
        ProductfeatureEntity productfeature = this.getProductFeature(code);
        return productfeature == null ? null : productfeature.getFeatureValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.productId == null ? 0 : this.productId.hashCode());
        result = 31 * result + (this.productfeatures == null ? 0 : this.productfeatures.hashCode());
        result = 31 * result + (this.validFrom == null ? 0 : this.validFrom.hashCode());
        result = 31 * result + (this.validTo == null ? 0 : this.validTo.hashCode());
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductEntity other = (ProductEntity)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.productId == null ? other.productId != null : !this.productId.equals(other.productId)) {
            return false;
        }
        if (this.productfeatures == null ? other.productfeatures != null : !this.productfeatures.equals(other.productfeatures)) {
            return false;
        }
        if (this.validFrom == null ? other.validFrom != null : !this.validFrom.equals(other.validFrom)) {
            return false;
        }
        if (this.validTo == null ? other.validTo != null : !this.validTo.equals(other.validTo)) {
            return false;
        }
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }

    public String toString() {
        return "ProductEntity [productId=" + this.productId + "]";
    }

    public String dump() {
        return "ProductEntity [productId=" + this.productId + ", name=" + this.name + ", validFrom=" + this.validFrom + ", validTo=" + this.validTo + ", code=" + this.code + ", productfeatures=" + this.productfeatures + "]";
    }

    public Product toDTO() {
        Product product = new Product();
        product.setProductId(this.productId);
        product.setName(this.name);
        product.setValidFrom(this.validFrom);
        product.setValidTo(this.validTo);
        return product;
    }
}

