/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.main;

import java.util.LinkedHashSet;
import org.junit.Assert;
import org.junit.Test;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.ShareEntity;
import pl.smartapps.restserver.db.main.UserEntity;

public class LanDeviceEntityTests {
    @Test
    public void testAddShareByShareObject() {
        LanDeviceEntity device = new LanDeviceEntity();
        Assert.assertEquals((long)0L, (long)device.getShares().size());
        ShareEntity share1 = new ShareEntity(Integer.valueOf(1));
        device.addShare(share1);
        Assert.assertEquals((long)1L, (long)device.getShares().size());
        ShareEntity share2 = new ShareEntity(Integer.valueOf(2));
        device.addShare(share2);
        Assert.assertEquals((long)2L, (long)device.getShares().size());
        LinkedHashSet<ShareEntity> expectedShares = new LinkedHashSet<ShareEntity>();
        expectedShares.add(share1);
        expectedShares.add(share2);
        Assert.assertEquals(expectedShares, (Object)device.getShares());
    }

    @Test
    public void testAddShareByUserObject() {
        LanDeviceEntity device = new LanDeviceEntity();
        Assert.assertEquals((long)0L, (long)device.getShares().size());
        UserEntity user1 = new UserEntity(Integer.valueOf(1), "user1", "user1@test.com", null);
        user1.setProduct(new ProductEntity());
        device.addShare(user1);
        Assert.assertEquals((long)1L, (long)device.getShares().size());
        UserEntity user2 = new UserEntity(Integer.valueOf(2), "user2", "user2@test.com", null);
        user2.setProduct(new ProductEntity());
        device.addShare(user2);
        Assert.assertEquals((long)2L, (long)device.getShares().size());
        LinkedHashSet<ShareEntity> expectedShares = new LinkedHashSet<ShareEntity>();
        expectedShares.add(new ShareEntity(null, "user1@test.com", device, user1));
        expectedShares.add(new ShareEntity(null, "user2@test.com", device, user2));
        Assert.assertEquals(expectedShares, (Object)device.getShares());
    }

    @Test
    public void testAddShareByEmail() {
        LanDeviceEntity device = new LanDeviceEntity();
        Assert.assertEquals((long)0L, (long)device.getShares().size());
        device.addShare("user1@test.com");
        Assert.assertEquals((long)1L, (long)device.getShares().size());
        device.addShare("user2@test.com");
        Assert.assertEquals((long)2L, (long)device.getShares().size());
        LinkedHashSet<ShareEntity> expectedShares = new LinkedHashSet<ShareEntity>();
        expectedShares.add(new ShareEntity(null, "user1@test.com", device, null));
        expectedShares.add(new ShareEntity(null, "user2@test.com", device, null));
        Assert.assertEquals(expectedShares, (Object)device.getShares());
    }

    @Test
    public void testRemoveShareByObject() {
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        ShareEntity share1 = new ShareEntity(Integer.valueOf(1));
        shares.add(share1);
        ShareEntity share2 = new ShareEntity(Integer.valueOf(2));
        shares.add(share2);
        ShareEntity share3 = new ShareEntity(Integer.valueOf(3));
        shares.add(share3);
        LanDeviceEntity device = new LanDeviceEntity();
        device.setShares(shares);
        Assert.assertEquals((long)3L, (long)device.getShares().size());
        device.removeShare(share2);
        Assert.assertEquals((long)2L, (long)device.getShares().size());
        LinkedHashSet<ShareEntity> expectedShares = new LinkedHashSet<ShareEntity>();
        expectedShares.add(share1);
        expectedShares.add(share3);
        Assert.assertEquals(expectedShares, (Object)device.getShares());
    }

    @Test
    public void testRemoveShareByEmail() {
        LanDeviceEntity device = new LanDeviceEntity();
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        device.setShares(shares);
        ShareEntity share1 = new ShareEntity(Integer.valueOf(1));
        shares.add(share1);
        UserEntity user1 = new UserEntity(Integer.valueOf(1));
        user1.setProduct(new ProductEntity());
        ShareEntity share2 = new ShareEntity(Integer.valueOf(2), null, device, user1);
        shares.add(share2);
        ShareEntity share3 = new ShareEntity(Integer.valueOf(3), "user3@test.com", device, null);
        shares.add(share3);
        device.setShares(shares);
        ShareEntity share4 = new ShareEntity(Integer.valueOf(4), "user4@test.com", device, null);
        shares.add(share4);
        Assert.assertEquals((long)4L, (long)device.getShares().size());
        device.removeShare("user4@test.com");
        Assert.assertEquals((long)3L, (long)device.getShares().size());
        LinkedHashSet<ShareEntity> expectedShares = new LinkedHashSet<ShareEntity>();
        expectedShares.add(share1);
        expectedShares.add(share2);
        expectedShares.add(share3);
        Assert.assertEquals(expectedShares, (Object)device.getShares());
    }

    @Test
    public void testRemoveShareByUserObjct() {
        LanDeviceEntity device = new LanDeviceEntity();
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        device.setShares(shares);
        ShareEntity share1 = new ShareEntity(Integer.valueOf(1));
        shares.add(share1);
        ShareEntity share2 = new ShareEntity(Integer.valueOf(2), "user2@test.com", device, null);
        shares.add(share2);
        UserEntity user3 = new UserEntity(Integer.valueOf(3), "user3", "user3@test.com", null);
        user3.setProduct(new ProductEntity());
        ShareEntity share3 = new ShareEntity(Integer.valueOf(3), null, device, user3);
        shares.add(share3);
        UserEntity user4 = new UserEntity(Integer.valueOf(4), "user4", "user4@test.com", null);
        user4.setProduct(new ProductEntity());
        ShareEntity share4 = new ShareEntity(Integer.valueOf(4), null, device, user4);
        shares.add(share4);
        Assert.assertEquals((long)4L, (long)device.getShares().size());
        device.removeShare(user4);
        Assert.assertEquals((long)3L, (long)device.getShares().size());
        LinkedHashSet<ShareEntity> expectedShares = new LinkedHashSet<ShareEntity>();
        expectedShares.add(share1);
        expectedShares.add(share2);
        expectedShares.add(share3);
        Assert.assertEquals(expectedShares, (Object)device.getShares());
    }
}

