/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.main;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.DeviceProduct;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.ProductfeatureEntity;
import pl.smartapps.restserver.db.main.ShareEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.VideoStreamParamsResponse;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.VideoStreamService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.util.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="landevice")
@NamedQueries(value={@NamedQuery(name="LanDeviceEntity.FIND_NOT_DELETED_BY_MAC_AND_USER_ID", query="select l from LanDeviceEntity l where l.mac = :mac and l.user.id = :userId and l.deleted = false"), @NamedQuery(name="LanDeviceEntity.FIND_BY_TOKEN", query="select l from LanDeviceEntity l where l.token = :token")})
public class LanDeviceEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="landevice_seq")
    @SequenceGenerator(name="landevice_seq", sequenceName="landevice_seq", allocationSize=1)
    @Basic(optional=false)
    @Column(name="landevice_id")
    private Integer lanDeviceId;
    @Basic(optional=false)
    @Column(name="name")
    private String name;
    @Column(name="description")
    private String description;
    @Column(name="location")
    private String location;
    @Basic(optional=false)
    @Column(name="added_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date addedDate;
    @Column(name="modified_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date modifiedDate;
    @Column(name="deleted_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deletedDate;
    @Basic(optional=false)
    @Column(name="mac")
    private String mac;
    @Basic(optional=false)
    @Column(name="ip_address")
    private String ipAddress;
    @Basic(optional=false)
    @Column(name="port")
    private Integer port;
    @Basic(optional=false)
    @Column(name="user_")
    private String username;
    @Column(name="pass", nullable=true)
    private String pass;
    @Column(name="version")
    private String version;
    @JoinColumn(name="gateway_client_id", referencedColumnName="gateway_client_id")
    @ManyToOne(cascade={CascadeType.PERSIST}, optional=false)
    private GatewayClientEntity gatewayClient;
    @JoinColumn(name="devicedesc_id", referencedColumnName="devicedesc_id")
    @ManyToOne(optional=false)
    private DeviceDescEntity deviceDesc;
    @JoinColumn(name="user_id", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private UserEntity user;
    @Basic(optional=false)
    @Column(name="deleted")
    private boolean deleted;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="lanDevice")
    private Set<EventEntity> events;
    @Column(name="configuration_status")
    @Enumerated(value=EnumType.STRING)
    private LanDevice.LanDeviceConfigurationStatus configurationStatus;
    @Basic(optional=false)
    @Column(name="valid_to")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date validTo;
    @Column(name="upgrade_status")
    @Enumerated(value=EnumType.STRING)
    private LanDevice.FirmwareUpgradeStatus upgradeStatus;
    @Column(name="upgrade_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date upgradeDate;
    @Column(name="model")
    private String model;
    @Column(name="video_encoding")
    @Basic(optional=false)
    private String videoEncoding;
    @JoinColumn(name="product_id", referencedColumnName="product_id")
    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    private ProductEntity product;
    @Basic(optional=false)
    @Column(name="product_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date productDate;
    @Basic(optional=true)
    @Column(name="trial_product_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date trialProductDate;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="lanDevice", orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<ShareEntity> shares = new LinkedHashSet();
    @Column(name="params")
    private String params;
    @Column(name="token")
    private String token;
    @Transient
    private List<LanDeviceParamEntity> lanDeviceParams = new ArrayList();
    @Transient
    private Boolean reconfiguration;

    public LanDeviceEntity() {
    }

    public LanDeviceEntity(Integer lanDeviceId) {
        this.lanDeviceId = lanDeviceId;
    }

    public LanDeviceEntity(Integer lanDeviceId, String name, Date addedDate, String mac, String ipAddress, Integer port, String username, String pass) {
        this.lanDeviceId = lanDeviceId;
        this.name = name;
        this.addedDate = addedDate;
        this.mac = mac;
        this.ipAddress = ipAddress;
        this.port = port;
        this.username = username;
        this.pass = pass;
    }

    public Integer getLanDeviceId() {
        return this.lanDeviceId;
    }

    public void setLanDeviceId(Integer lanDeviceId) {
        this.lanDeviceId = lanDeviceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Date getAddedDate() {
        return this.addedDate;
    }

    public void setAddedDate(Date addedDate) {
        this.addedDate = addedDate;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Date getDeletedDate() {
        return this.deletedDate;
    }

    public void setDeletedDate(Date deletedDate) {
        this.deletedDate = deletedDate;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPass() {
        return this.pass == null ? "" : this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<LanDeviceParamEntity> getLanDeviceParams() {
        return this.lanDeviceParams;
    }

    public void setLanDeviceParams(List<LanDeviceParamEntity> lanDeviceParams) {
        this.lanDeviceParams = lanDeviceParams;
    }

    public GatewayClientEntity getGatewayClient() {
        return this.gatewayClient;
    }

    public void setGatewayClient(GatewayClientEntity gatewayClient) {
        this.gatewayClient = gatewayClient;
    }

    public DeviceDescEntity getDeviceDesc() {
        return this.deviceDesc;
    }

    public void setDeviceDesc(DeviceDescEntity deviceDesc) {
        this.deviceDesc = deviceDesc;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Set<EventEntity> getEvents() {
        return this.events;
    }

    public void setEvents(Set<EventEntity> events) {
        this.events = events;
    }

    public LanDevice.LanDeviceConfigurationStatus getConfigurationStatus() {
        return this.configurationStatus;
    }

    public void setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus configurationStatus) {
        this.configurationStatus = configurationStatus;
    }

    public Boolean getReconfiguration() {
        return this.reconfiguration;
    }

    public void setReconfiguration(Boolean reconfiguration) {
        this.reconfiguration = reconfiguration;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public void setValidTo(Date validTo) {
        this.validTo = validTo;
    }

    public LanDevice.FirmwareUpgradeStatus getUpgradeStatus() {
        return this.upgradeStatus;
    }

    public void setUpgradeStatus(LanDevice.FirmwareUpgradeStatus upgradeStatus) {
        this.upgradeStatus = upgradeStatus;
    }

    public Date getUpgradeDate() {
        return this.upgradeDate;
    }

    public void setUpgradeDate(Date upgradeDate) {
        this.upgradeDate = upgradeDate;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getVideoEncoding() {
        return this.videoEncoding;
    }

    public void setVideoEncoding(String videoEncoding) {
        this.videoEncoding = videoEncoding;
    }

    public ProductEntity getProduct() {
        return this.product;
    }

    public void setProduct(ProductEntity product) {
        this.product = product;
    }

    public Date getProductDate() {
        return this.productDate;
    }

    public void setProductDate(Date productDate) {
        this.productDate = productDate;
    }

    public Date getTrialProductDate() {
        return this.trialProductDate;
    }

    public void setTrialProductDate(Date trialProductDate) {
        this.trialProductDate = trialProductDate;
    }

    public Set<ShareEntity> getShares() {
        return this.shares;
    }

    public void setShares(LinkedHashSet<ShareEntity> shares) {
        this.shares = shares;
    }

    public void addShare(ShareEntity share) {
        this.shares.add(share);
    }

    public boolean addShare(UserEntity user) {
        ShareEntity share = new ShareEntity();
        share.setLanDevice(this);
        share.setUser(user);
        share.setEmail(user.getEmail());
        return this.shares.add(share);
    }

    public boolean addShare(String email) {
        ShareEntity share = new ShareEntity();
        share.setLanDevice(this);
        share.setEmail(email);
        return this.shares.add(share);
    }

    public boolean removeShare(ShareEntity share) {
        return this.shares.remove(share);
    }

    public boolean removeShare(String email) {
        ShareEntity share = this.getShare(email);
        if (share == null) {
            return false;
        }
        return this.shares.remove(share);
    }

    private ShareEntity getShare(String email) {
        for (ShareEntity share : this.shares) {
            if (share.getEmail() == null || !share.getEmail().equals(email)) continue;
            return share;
        }
        return null;
    }

    public ShareEntity getShare(Integer userId) {
        for (ShareEntity share : this.shares) {
            if (share.getUser() == null || !share.getUser().getId().equals(userId)) continue;
            return share;
        }
        return null;
    }

    public boolean removeShare(UserEntity user) {
        ShareEntity share = this.getShare(user);
        if (share == null) {
            return false;
        }
        return this.shares.remove(share);
    }

    private ShareEntity getShare(UserEntity user) {
        for (ShareEntity share : this.shares) {
            if (share.getUser() == null || !share.getUser().getId().equals(user.getId())) continue;
            return share;
        }
        return null;
    }

    public String getNameForUserId(Integer userId) {
        ShareEntity share = this.getShare(userId);
        if (share != null && share.getName() != null && !share.getName().isEmpty()) {
            return share.getName();
        }
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addedDate == null ? 0 : this.addedDate.hashCode());
        result = 31 * result + (this.configurationStatus == null ? 0 : this.configurationStatus.hashCode());
        result = 31 * result + (this.deleted ? 1231 : 1237);
        result = 31 * result + (this.deletedDate == null ? 0 : this.deletedDate.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.deviceDesc == null ? 0 : this.deviceDesc.hashCode());
        result = 31 * result + (this.gatewayClient == null ? 0 : this.gatewayClient.hashCode());
        result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 31 * result + (this.lanDeviceId == null ? 0 : this.lanDeviceId.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.mac == null ? 0 : this.mac.hashCode());
        result = 31 * result + (this.modifiedDate == null ? 0 : this.modifiedDate.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pass == null ? 0 : this.pass.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.reconfiguration == null ? 0 : this.reconfiguration.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.validTo == null ? 0 : this.validTo.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.upgradeStatus == null ? 0 : this.upgradeStatus.hashCode());
        result = 31 * result + (this.upgradeDate == null ? 0 : this.upgradeDate.hashCode());
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.videoEncoding == null ? 0 : this.videoEncoding.hashCode());
        result = 31 * result + (this.product == null ? 0 : this.product.hashCode());
        result = 31 * result + (this.productDate == null ? 0 : this.productDate.hashCode());
        result = 31 * result + (this.trialProductDate == null ? 0 : this.trialProductDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LanDeviceEntity other = (LanDeviceEntity)obj;
        if (this.addedDate == null ? other.addedDate != null : !this.addedDate.equals(other.addedDate)) {
            return false;
        }
        if (this.configurationStatus == null ? other.configurationStatus != null : !this.configurationStatus.equals((Object)other.configurationStatus)) {
            return false;
        }
        if (this.deleted != other.deleted) {
            return false;
        }
        if (this.deletedDate == null ? other.deletedDate != null : !this.deletedDate.equals(other.deletedDate)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.deviceDesc == null ? other.deviceDesc != null : !this.deviceDesc.equals((Object)other.deviceDesc)) {
            return false;
        }
        if (this.gatewayClient == null ? other.gatewayClient != null : !this.gatewayClient.equals((Object)other.gatewayClient)) {
            return false;
        }
        if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
            return false;
        }
        if (this.lanDeviceId == null ? other.lanDeviceId != null : !this.lanDeviceId.equals(other.lanDeviceId)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.mac == null ? other.mac != null : !this.mac.equals(other.mac)) {
            return false;
        }
        if (this.modifiedDate == null ? other.modifiedDate != null : !this.modifiedDate.equals(other.modifiedDate)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.pass == null ? other.pass != null : !this.pass.equals(other.pass)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        if (this.reconfiguration == null ? other.reconfiguration != null : !this.reconfiguration.equals(other.reconfiguration)) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        if (this.validTo == null ? other.validTo != null : !this.validTo.equals(other.validTo)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.upgradeStatus == null ? other.upgradeStatus != null : !this.upgradeStatus.equals((Object)other.upgradeStatus)) {
            return false;
        }
        if (this.upgradeDate == null ? other.upgradeDate != null : !this.upgradeDate.equals(other.upgradeDate)) {
            return false;
        }
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.videoEncoding == null ? other.videoEncoding != null : !this.videoEncoding.equals(other.videoEncoding)) {
            return false;
        }
        if (this.product == null ? other.product != null : !this.product.equals((Object)other.product)) {
            return false;
        }
        if (this.productDate == null ? other.productDate != null : !this.productDate.equals(other.productDate)) {
            return false;
        }
        return !(this.trialProductDate == null ? other.trialProductDate != null : !this.trialProductDate.equals(other.trialProductDate));
    }

    public String toString() {
        return "LanDevice [lanDeviceId=" + this.lanDeviceId + "]";
    }

    public String dump() {
        return "LanDevice [lanDeviceId=" + this.lanDeviceId + ", name=" + this.name + ", description=" + this.description + ", location=" + this.location + ", addedDate=" + this.addedDate + ", modifiedDate=" + this.modifiedDate + ", deletedDate=" + this.deletedDate + ", mac=" + this.mac + ", ipAddress=" + this.ipAddress + ", port=" + this.port + ", username=" + this.username + ", version=" + this.version + ", validTo=" + this.validTo + ", lanDeviceParams=" + this.lanDeviceParams + ", deleted=" + this.deleted + ", configurationStatus=" + this.configurationStatus + ", gatewayClient=" + this.gatewayClient + ", deviceDesc=" + this.deviceDesc + ", reconfiguration=" + this.reconfiguration + ", upgradeStatus=" + this.upgradeStatus + ", upgradeDate=" + this.upgradeDate + ", model=" + this.model + ", videoEncoding=" + this.videoEncoding + ", model=" + this.model + ",product=" + (this.product == null ? "null" : this.product.getName()) + ", productDate=" + this.productDate + ", trialProductDate=" + this.trialProductDate + ", params=" + this.params + "]";
    }

    public LanDevice toDTO(GatewayDeviceConnectionService gatewayDeviceConnection, DeviceDriverFactory driverFactory, boolean attachDeviceDesc, boolean attachGatewayClient, boolean attachParams, VideoStreamService videoStreamService, ProductManagementService productManagementService) {
        return this.toDTO(gatewayDeviceConnection, driverFactory, attachDeviceDesc, attachGatewayClient, attachParams, videoStreamService, productManagementService, null);
    }

    public LanDevice toDTO(GatewayDeviceConnectionService gatewayDeviceConnection, DeviceDriverFactory driverFactory, boolean attachDeviceDesc, boolean attachGatewayClient, boolean attachParams, VideoStreamService videoStreamService, ProductManagementService productManagementService, Integer currentUserId) {
        GenericLanDevice driver;
        LanDevice dto = new LanDevice();
        dto.setLanDeviceId(this.lanDeviceId);
        dto.setAddedDate(this.addedDate);
        dto.setModifiedDate(this.modifiedDate);
        dto.setDeletedDate(this.deletedDate);
        dto.setDeleted(Boolean.valueOf(this.deleted));
        dto.setDescription(this.description);
        dto.setIpAddress(this.ipAddress);
        dto.setLocation(this.location);
        dto.setMac(this.mac);
        dto.setName(this.getNameForUserId(currentUserId != null ? currentUserId : this.user.getId()));
        dto.setPass(this.pass);
        dto.setPort(this.port);
        dto.setUser(this.username);
        dto.setVersion(this.version);
        dto.setValidTo(this.validTo);
        dto.setRecording(Boolean.valueOf(false));
        dto.setReconfiguration(this.reconfiguration);
        dto.setUpgradeStatus(this.upgradeStatus);
        dto.setUpgradeDate(this.upgradeDate);
        dto.setConfigurationStatus(this.configurationStatus);
        dto.setVideoEncoding(this.videoEncoding);
        dto.setProductDate(this.productDate);
        dto.setTrialProductDate(this.trialProductDate);
        dto.setOwnerId(this.user.getId());
        dto.setOwnerEmail(this.user.getEmail());
        dto.setShared(!this.getShares().isEmpty());
        if (currentUserId != null) {
            dto.setBelongsToCurrentUser(currentUserId.equals(this.user.getId()));
        }
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(this.product.getProductId());
        if (productManagementService != null) {
            deviceProduct.setType(productManagementService.getDeviceProductType(this.lanDeviceId));
        }
        deviceProduct.setName(this.product.getName());
        deviceProduct.setCode(this.product.getCode());
        deviceProduct.setValidFrom(this.product.getValidFrom());
        deviceProduct.setValidTo(this.product.getValidTo());
        for (ProductfeatureEntity productfeature : this.product.getProductfeatures()) {
            DeviceFeatureCode code = DeviceFeatureCode.valueOf((String)productfeature.getFeature().getFeatureCode());
            deviceProduct.setFeature(code, productfeature.getFeatureValue());
        }
        dto.setProduct(deviceProduct);
        dto.setHasHome(Boolean.valueOf("ON".equals(this.getParamValue("has_home"))));
        dto.setHasPan(Boolean.valueOf("ON".equals(this.getParamValue("has_pan"))));
        dto.setHasTilt(Boolean.valueOf("ON".equals(this.getParamValue("has_tilt"))));
        dto.setHasZoom(Boolean.valueOf("ON".equals(this.getParamValue("has_zoom"))));
        dto.setNeedsRestartAfterNetworkChanges(Boolean.valueOf("ON".equals(this.getParamValue("need_restart_after_network_changes"))));
        dto.setNeedsRestartAfterNetworkChangesToWireless(Boolean.valueOf("ON".equals(this.getParamValue("need_restart_after_network_changes_to_wireless"))));
        dto.setNeedsRestartAfterNetworkChangesToEthernet(Boolean.valueOf("ON".equals(this.getParamValue("need_restart_after_network_changes_to_ethernet"))));
        dto.setHasIllumination(Boolean.valueOf(this.hasParam("illumination")));
        dto.setHasMotionDetection(Boolean.valueOf(this.hasParam("motion_detection")));
        dto.setHasAudioDetection(Boolean.valueOf(this.hasParam("audio_detection")));
        dto.setHasLedControl(Boolean.valueOf(this.hasParam("system_ledoff")));
        dto.setHasPrivacyButtonControl(Boolean.valueOf(this.hasParam("privacy_button")));
        dto.setHasMuteAudio(Boolean.valueOf("ON".equals(this.getParamValue("has_mute_audio"))));
        if (attachDeviceDesc && this.deviceDesc != null) {
            dto.setDeviceDesc(this.deviceDesc.toDTO());
        }
        if (attachGatewayClient && this.gatewayClient != null) {
            dto.setGatewayClient(this.gatewayClient.toDTO(gatewayDeviceConnection, driverFactory, false, false));
        }
        if (attachParams && this.lanDeviceParams != null) {
            dto.setLanDeviceParams(LanDeviceParamEntity.toDTOs((List)this.lanDeviceParams));
        }
        if (driverFactory != null && (driver = driverFactory.getDriver(this)) != null) {
            dto.setConnCheckUrl(driver.getConnCheckUrl());
            dto.setFirmwareUpToDate(driver.isFirmwareUpToDate(this));
        }
        if (videoStreamService != null && !this.deviceDesc.getClassDevice().equals("nas")) {
            try {
                VideoStreamParamsResponse paramsResponse = videoStreamService.getVideoStreamPameters(this.lanDeviceId, true);
                if (paramsResponse.status == VideoStreamParamsResponse.VideoStreamResponseStatus.OK) {
                    dto.setVideoStreamParams(paramsResponse.params);
                }
            }
            catch (InvalidSessionException e) {
                e.printStackTrace();
            }
        }
        return dto;
    }

    public static List<LanDevice> toDTOs(GatewayDeviceConnectionService gatewayDeviceConnection, DeviceDriverFactory driverFactory, List<LanDeviceEntity> devices, boolean attachDeviceDesc, boolean attachGatewayClient, boolean attachParams, VideoStreamService videoStreamService, ProductManagementService productManagementService) {
        return LanDeviceEntity.toDTOs((GatewayDeviceConnectionService)gatewayDeviceConnection, (DeviceDriverFactory)driverFactory, devices, (boolean)attachDeviceDesc, (boolean)attachGatewayClient, (boolean)attachParams, (VideoStreamService)videoStreamService, (ProductManagementService)productManagementService, null);
    }

    public static List<LanDevice> toDTOs(GatewayDeviceConnectionService gatewayDeviceConnection, DeviceDriverFactory driverFactory, List<LanDeviceEntity> devices, boolean attachDeviceDesc, boolean attachGatewayClient, boolean attachParams, VideoStreamService videoStreamService, ProductManagementService productManagementService, Integer currentUserId) {
        ArrayList<LanDevice> dtos = new ArrayList<LanDevice>();
        for (LanDeviceEntity device : devices) {
            dtos.add(device.toDTO(gatewayDeviceConnection, driverFactory, attachDeviceDesc, attachGatewayClient, attachParams, videoStreamService, productManagementService, currentUserId));
        }
        return dtos;
    }

    public LanDeviceEntity(LanDevice device, boolean attachDeviceDesc, boolean attachGatewayClient, boolean attachParams) {
        this.addedDate = device.getAddedDate();
        this.modifiedDate = device.getModifiedDate();
        this.deletedDate = device.getDeletedDate();
        this.deleted = device.getDeleted() == null ? false : device.getDeleted();
        this.description = device.getDescription();
        this.ipAddress = device.getIpAddress();
        this.lanDeviceId = device.getLanDeviceId();
        this.location = device.getLocation();
        this.mac = device.getMac();
        this.name = device.getName();
        this.pass = device.getPass();
        this.port = device.getPort();
        this.username = device.getUser();
        this.version = device.getVersion();
        this.reconfiguration = device.getReconfiguration() == null ? false : device.getReconfiguration();
        if (attachDeviceDesc && device.getDeviceDesc() != null) {
            this.setDeviceDesc(new DeviceDescEntity(device.getDeviceDesc()));
        }
        if (attachGatewayClient && device.getGatewayClient() != null) {
            this.setGatewayClient(new GatewayClientEntity(device.getGatewayClient()));
        }
    }

    public ProductfeatureEntity getProductFeature(DeviceFeatureCode code) {
        if (code == null) {
            return null;
        }
        for (ProductfeatureEntity productfeature : this.product.getProductfeatures()) {
            if (!productfeature.getFeature().getFeatureCode().equals(code.name())) continue;
            return productfeature;
        }
        return null;
    }

    public String getProductFeatureValue(DeviceFeatureCode code) {
        ProductfeatureEntity productfeature = this.getProductFeature(code);
        return productfeature == null ? null : productfeature.getFeatureValue();
    }

    public LanDeviceParamEntity getParam(String paramName) {
        if (paramName == null || paramName.trim().isEmpty()) {
            return null;
        }
        for (LanDeviceParamEntity param : this.lanDeviceParams) {
            if (!param.getName().equals(paramName)) continue;
            return param;
        }
        return null;
    }

    public String getParamValue(String paramName) {
        LanDeviceParamEntity param = this.getParam(paramName);
        if (param != null) {
            return param.getValue();
        }
        return null;
    }

    public boolean hasParam(String paramName) {
        return this.getParam(paramName) != null;
    }

    public void setParam(String paramName, String paramValue) {
        this.setParam(paramName, paramValue, null);
    }

    public void setParam(String paramName, String paramValue, String paramRemoteValue) {
        LanDeviceParamEntity param = this.getParam(paramName);
        if (param == null) {
            param = new LanDeviceParamEntity();
            this.lanDeviceParams.add(param);
        }
        param.setName(paramName);
        param.setValue(paramValue);
        param.setRemoteValue(paramRemoteValue);
    }

    public void removeParam(String paramName) {
        Integer index = this.getParamIndex(paramName);
        if (index != null) {
            this.lanDeviceParams.remove(index);
        }
    }

    private Integer getParamIndex(String paramName) {
        if (paramName == null || paramName.trim().isEmpty()) {
            return -1;
        }
        int i = 0;
        while (i < this.lanDeviceParams.size()) {
            if (((LanDeviceParamEntity)this.lanDeviceParams.get(i)).getName().equals(paramName)) {
                return i;
            }
            ++i;
        }
        return null;
    }

    public void materialize() {
        Gson gson = new Gson();
        this.lanDeviceParams = Utils.isBlank((String)this.params) ? new ArrayList() : (List)gson.fromJson(this.params, new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    public void dematerialize() {
        this.dematerializeParams();
    }

    private void dematerializeParams() {
        Gson gson = new Gson();
        this.params = gson.toJson((Object)this.lanDeviceParams);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

