/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.main;

import com.vestiacom.gdserver.rest.response.GatewayDevice;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="gatewayclientsession")
@NamedQueries(value={@NamedQuery(name="GatewayClientEntity.FIND_BY_MAC", query="select g from GatewayClientSessionEntity g where g.mac = :mac"), @NamedQuery(name="GatewayClientEntity.FIND_ALL", query="select g from GatewayClientSessionEntity g")})
public class GatewayClientSessionEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @Column(name="mac")
    private String mac;
    @Basic(optional=false)
    @Column(name="public_ip")
    private String publicIp;
    @Basic(optional=true)
    @Column(name="version")
    private String version;
    @Basic(optional=true)
    @Column(name="build_no")
    private Integer buildNo;
    @Basic(optional=false)
    @Column(name="connected_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date connectedDate;
    @Basic(optional=false)
    @Column(name="last_alive")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastAlive;
    @Basic(optional=false)
    @Column(name="encrypted")
    private boolean encrypted;
    @Column(name="server_url")
    private String serverUrl;

    public GatewayClientSessionEntity() {
    }

    public GatewayClientSessionEntity(String mac, String publicIp, String version, Integer buildNo, Date connectedDate, Date lastAlive, boolean encrypted, String serverUrl) {
        this.publicIp = publicIp;
        this.mac = mac;
        this.version = version;
        this.buildNo = buildNo;
        this.connectedDate = connectedDate;
        this.lastAlive = lastAlive;
        this.encrypted = encrypted;
        this.serverUrl = serverUrl;
    }

    public GatewayClientSessionEntity(GatewayDevice gd, String serverUrl) {
        this(gd.getMac(), gd.getPublicIpAddress(), gd.getVersion(), gd.getBuildNo(), gd.getConnectedDate(), new Date(gd.getLastAlive()), gd.isEncryptedControlConnection(), serverUrl);
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Integer getBuildNo() {
        return this.buildNo;
    }

    public void setBuildNo(Integer buildNo) {
        this.buildNo = buildNo;
    }

    public Date getConnectedDate() {
        return this.connectedDate;
    }

    public void setConnectedDate(Date connectedDate) {
        this.connectedDate = connectedDate;
    }

    public Date getLastAlive() {
        return this.lastAlive;
    }

    public void setLastAlive(Date lastAlive) {
        this.lastAlive = lastAlive;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.buildNo == null ? 0 : this.buildNo.hashCode());
        result = 31 * result + (this.connectedDate == null ? 0 : this.connectedDate.hashCode());
        result = 31 * result + (this.encrypted ? 1231 : 1237);
        result = 31 * result + (this.lastAlive == null ? 0 : this.lastAlive.hashCode());
        result = 31 * result + (this.mac == null ? 0 : this.mac.hashCode());
        result = 31 * result + (this.publicIp == null ? 0 : this.publicIp.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.serverUrl == null ? 0 : this.serverUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GatewayClientSessionEntity other = (GatewayClientSessionEntity)obj;
        if (this.buildNo == null ? other.buildNo != null : !this.buildNo.equals(other.buildNo)) {
            return false;
        }
        if (this.connectedDate == null ? other.connectedDate != null : !this.connectedDate.equals(other.connectedDate)) {
            return false;
        }
        if (this.encrypted != other.encrypted) {
            return false;
        }
        if (this.lastAlive == null ? other.lastAlive != null : !this.lastAlive.equals(other.lastAlive)) {
            return false;
        }
        if (this.mac == null ? other.mac != null : !this.mac.equals(other.mac)) {
            return false;
        }
        if (this.publicIp == null ? other.publicIp != null : !this.publicIp.equals(other.publicIp)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.serverUrl == null ? other.serverUrl != null : !this.serverUrl.equals(other.serverUrl));
    }

    public String toString() {
        return "GatewayClientSessionEntity [mac=" + this.mac + "]";
    }

    public String dump() {
        return "GatewayClientSessionEntity [mac=" + this.mac + ", publicIp=" + this.publicIp + ", version=" + this.version + ", buildNo=" + this.buildNo + ", connectedDate=" + this.connectedDate + ", lastAlive=" + this.lastAlive + ", encrypted=" + this.encrypted + ", serverUrl=" + this.serverUrl + "]";
    }
}

