/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.main;

import com.vestiacom.gdserver.rest.response.GatewayDevice;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.hm.WebViewer.shared.model.GatewayClient;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.UserEntity;

@Entity
@Table(name="gatewayclient")
@NamedQueries(value={@NamedQuery(name="GatewayClientEntity.FIND_NOT_DELETED_BY_MAC", query="select g from GatewayClientEntity g where g.mac = :mac and g.deleted = false"), @NamedQuery(name="GatewayClientEntity.FIND_NOT_DELETED_BY_ID_AND_USER_ID", query="select g from GatewayClientEntity g where g.gatewayClientId = :gatewayClientId and g.user.id = :userId and g.deleted = false"), @NamedQuery(name="GatewayClientEntity.FIND_NOT_DELETED_BY_MAC_AND_USER_ID", query="select g from GatewayClientEntity g where g.mac = :mac and g.user.id = :userId and g.deleted = false")})
public class GatewayClientEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="gatewayclient_seq")
    @SequenceGenerator(name="gatewayclient_seq", sequenceName="gatewayclient_seq", allocationSize=1)
    @Basic(optional=false)
    @Column(name="gateway_client_id")
    private Integer gatewayClientId;
    @Basic(optional=false)
    @Column(name="mac")
    private String mac;
    @Basic(optional=false)
    @Column(name="name")
    private String name;
    @Basic(optional=false)
    @Column(name="serial_number")
    private String serialNumber;
    @Column(name="modification_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date modificationDate;
    @Basic(optional=false)
    @Column(name="activation_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date activationDate;
    @JoinColumn(name="user_id", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    private UserEntity user;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="gatewayClient")
    private Set<LanDeviceEntity> lanDevices;
    @Basic(optional=false)
    @Column(name="deleted")
    private boolean deleted;
    @Basic(optional=false)
    @Column(name="device_type")
    private Integer deviceType;
    @Column(name="log_conf")
    private String logConf;
    @Column(name="upnp_port")
    @Basic(optional=true)
    private Integer upnpPort = 0;
    @Column(name="upnp_reason")
    @Basic(optional=true)
    private String upnpReason = "none";
    @Column(name="upnp_address")
    @Basic(optional=true)
    private String upnpAddress;
    @Column(name="domain_record_id")
    @Basic(optional=true)
    private Integer domainRecordId;
    @Column(name="local_domain_record_id")
    @Basic(optional=true)
    private Integer localDomainRecordId;
    @Column(name="local_address_dns")
    @Basic(optional=true)
    private String localAddressDns;
    @Basic(optional=true)
    @Column(name="version")
    private String version;
    @Column(name="build_no")
    private Integer buildNo;
    @Column(name="connected_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date connectedDate;
    @Column(name="disconnected_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date disconnectedDate;
    @Basic(optional=false)
    @Column(name="force_reboot")
    private boolean forceReboot;

    public String getUpnpReason() {
        return this.upnpReason;
    }

    public void setUpnpReason(String upnpReason) {
        this.upnpReason = upnpReason;
    }

    public GatewayClientEntity() {
    }

    public GatewayClientEntity(Integer gatewayClientId) {
        this.gatewayClientId = gatewayClientId;
    }

    public GatewayClientEntity(Integer gatewayClientId, String mac, String name, String serialNumber, Date activationDate) {
        this.gatewayClientId = gatewayClientId;
        this.mac = mac;
        this.name = name;
        this.serialNumber = serialNumber;
        this.activationDate = activationDate;
    }

    public GatewayClientEntity(GatewayClient gatewayClient) {
        this.activationDate = gatewayClient.getActivationDate();
        this.gatewayClientId = gatewayClient.getGatewayClientId();
        this.mac = gatewayClient.getMac();
        this.modificationDate = gatewayClient.getModificationDate();
        this.name = gatewayClient.getName();
        this.serialNumber = gatewayClient.getSerialNumber();
        this.deviceType = gatewayClient.getDeviceType();
        this.logConf = gatewayClient.getLogConf();
    }

    public Integer getGatewayClientId() {
        return this.gatewayClientId;
    }

    public void setGatewayClientId(Integer gatewayClientId) {
        this.gatewayClientId = gatewayClientId;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Date getActivationDate() {
        return this.activationDate;
    }

    public void setActivationDate(Date activationDate) {
        this.activationDate = activationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public Set<LanDeviceEntity> getLanDevices() {
        return this.lanDevices;
    }

    public void setLanDevices(Set<LanDeviceEntity> lanDevices) {
        this.lanDevices = lanDevices;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Integer getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    public String getLogConf() {
        return this.logConf;
    }

    public void setLogConf(String logConf) {
        this.logConf = logConf;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Integer getBuildNo() {
        return this.buildNo;
    }

    public void setBuildNo(Integer buildNo) {
        this.buildNo = buildNo;
    }

    public Date getConnectedDate() {
        return this.connectedDate;
    }

    public void setConnectedDate(Date connectedDate) {
        this.connectedDate = connectedDate;
    }

    public Date getDisconnectedDate() {
        return this.disconnectedDate;
    }

    public void setDisconnectedDate(Date disconnectedDate) {
        this.disconnectedDate = disconnectedDate;
    }

    public Integer getUpnpPort() {
        return this.upnpPort;
    }

    public void setUpnpPort(Integer upnpPort) {
        this.upnpPort = upnpPort;
    }

    public String getUpnpAddress() {
        return this.upnpAddress;
    }

    public void setUpnpAddress(String upnpAddress) {
        this.upnpAddress = upnpAddress;
    }

    public Integer getDomainRecordId() {
        return this.domainRecordId;
    }

    public void setDomainRecordId(Integer domainRecordId) {
        this.domainRecordId = domainRecordId;
    }

    public Integer getLocalDomainRecordId() {
        return this.localDomainRecordId;
    }

    public void setLocalDomainRecordId(Integer localDomainRecordId) {
        this.localDomainRecordId = localDomainRecordId;
    }

    public void setLocalAddressDns(String address) {
        this.localAddressDns = address;
    }

    public String getLocalAddressDns() {
        return this.localAddressDns;
    }

    public void setForceReboot(boolean forceReboot) {
        this.forceReboot = forceReboot;
    }

    public boolean isForceReboot() {
        return this.forceReboot;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activationDate == null ? 0 : this.activationDate.hashCode());
        result = 31 * result + (this.deleted ? 1231 : 1237);
        result = 31 * result + (this.deviceType == null ? 0 : this.deviceType.hashCode());
        result = 31 * result + (this.gatewayClientId == null ? 0 : this.gatewayClientId.hashCode());
        result = 31 * result + (this.logConf == null ? 0 : this.logConf.hashCode());
        result = 31 * result + (this.mac == null ? 0 : this.mac.hashCode());
        result = 31 * result + (this.modificationDate == null ? 0 : this.modificationDate.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.serialNumber == null ? 0 : this.serialNumber.hashCode());
        result = 31 * result + (this.upnpPort == null ? 0 : this.upnpPort.hashCode());
        result = 31 * result + (this.upnpReason == null ? 0 : this.upnpReason.hashCode());
        result = 31 * result + (this.upnpAddress == null ? 0 : this.upnpAddress.hashCode());
        result = 31 * result + (this.localAddressDns == null ? 0 : this.localAddressDns.hashCode());
        result = 31 * result + (this.domainRecordId == null ? 0 : this.domainRecordId.hashCode());
        result = 31 * result + (this.localDomainRecordId == null ? 0 : this.localDomainRecordId.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.buildNo == null ? 0 : this.buildNo.hashCode());
        result = 31 * result + (this.connectedDate == null ? 0 : this.connectedDate.hashCode());
        result = 31 * result + (this.disconnectedDate == null ? 0 : this.disconnectedDate.hashCode());
        result = 31 * result + (this.forceReboot ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GatewayClientEntity other = (GatewayClientEntity)obj;
        if (this.activationDate == null ? other.activationDate != null : !this.activationDate.equals(other.activationDate)) {
            return false;
        }
        if (this.deleted != other.deleted) {
            return false;
        }
        if (this.deviceType == null ? other.deviceType != null : !this.deviceType.equals(other.deviceType)) {
            return false;
        }
        if (this.gatewayClientId == null ? other.gatewayClientId != null : !this.gatewayClientId.equals(other.gatewayClientId)) {
            return false;
        }
        if (this.logConf == null ? other.logConf != null : !this.logConf.equals(other.logConf)) {
            return false;
        }
        if (this.mac == null ? other.mac != null : !this.mac.equals(other.mac)) {
            return false;
        }
        if (this.modificationDate == null ? other.modificationDate != null : !this.modificationDate.equals(other.modificationDate)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.serialNumber == null ? other.serialNumber != null : !this.serialNumber.equals(other.serialNumber)) {
            return false;
        }
        if (this.upnpPort == null ? other.upnpPort != null : !this.upnpPort.equals(other.upnpPort)) {
            return false;
        }
        if (this.upnpReason == null ? other.upnpReason != null : !this.upnpReason.equals(other.upnpReason)) {
            return false;
        }
        if (this.upnpAddress == null ? other.upnpAddress != null : !this.upnpAddress.equals(other.upnpAddress)) {
            return false;
        }
        if (this.localAddressDns == null ? other.localAddressDns != null : !this.localAddressDns.equals(other.localAddressDns)) {
            return false;
        }
        if (this.domainRecordId == null ? other.domainRecordId != null : !this.domainRecordId.equals(other.domainRecordId)) {
            return false;
        }
        if (this.localDomainRecordId == null ? other.localDomainRecordId != null : !this.localDomainRecordId.equals(other.localDomainRecordId)) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals((Object)other.user)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.buildNo == null ? other.buildNo != null : !this.buildNo.equals(other.buildNo)) {
            return false;
        }
        if (this.connectedDate == null ? other.connectedDate != null : !this.connectedDate.equals(other.connectedDate)) {
            return false;
        }
        if (this.disconnectedDate == null ? other.disconnectedDate != null : !this.disconnectedDate.equals(other.disconnectedDate)) {
            return false;
        }
        return this.forceReboot == other.forceReboot;
    }

    public String toString() {
        return "GatewayClient [gatewayClientId=" + this.gatewayClientId + "]";
    }

    public String dump() {
        return "GatewayClient [gatewayClientId=" + this.gatewayClientId + ", mac=" + this.mac + ", name=" + this.name + ", serialNumber=" + this.serialNumber + ", modificationDate=" + this.modificationDate + ", activationDate=" + this.activationDate + ", connectedDate=" + this.connectedDate + ", disconnectedDate=" + this.disconnectedDate + ", user=" + this.user + ", deleted=" + this.deleted + ", deviceType=" + this.deviceType + ", version=" + this.version + ", buildNo=" + this.buildNo + ", logConf=" + this.logConf + ", upnpReason=" + this.upnpReason + ", upnpPort=" + this.upnpPort + ", upnpAddress=" + this.upnpAddress + ", domainRecordId=" + this.domainRecordId + ", localDomainRecordId=" + this.localDomainRecordId + ", localAddressDns=" + this.localAddressDns + ", forceReboot=" + this.forceReboot + "]";
    }

    public GatewayClient toDTO(GatewayDeviceConnectionService gatewayDeviceConnection, DeviceDriverFactory driverFactory, boolean attachLanDevices, boolean attachLanDeviceParams) {
        GatewayClient dto = new GatewayClient();
        dto.setActivationDate(this.activationDate);
        dto.setGatewayClientId(this.gatewayClientId);
        dto.setMac(this.mac);
        dto.setModificationDate(this.modificationDate);
        dto.setName(this.name);
        dto.setSerialNumber(this.serialNumber);
        dto.setDeleted(Boolean.valueOf(this.deleted));
        dto.setDeviceType(this.deviceType);
        dto.setLogConf(this.logConf);
        dto.setVersion(this.version);
        dto.setBuildNo(this.buildNo);
        dto.setConnectedDate(this.connectedDate);
        dto.setDisconnectedDate(this.disconnectedDate);
        dto.setUpnpPort(this.upnpPort);
        dto.setUpnpReason(this.upnpReason);
        dto.setUpnpAddress(this.upnpAddress);
        dto.setLocalIpAddressDns(this.localAddressDns);
        if (gatewayDeviceConnection != null) {
            GatewayDevice gatewayDevice = gatewayDeviceConnection.findById(this.mac);
            if (gatewayDevice == null) {
                dto.setStatus(GatewayClient.GatewayClientStatus.DISCONNECTED);
            } else {
                dto.setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
                dto.setPublicIpAddress(gatewayDevice.getPublicIpAddress());
                dto.setLocalIpAddress(gatewayDevice.getLocalIpAddress());
            }
        }
        if (attachLanDevices) {
            ArrayList lds = new ArrayList(this.lanDevices);
            dto.setLanDevices(LanDeviceEntity.toDTOs((GatewayDeviceConnectionService)gatewayDeviceConnection, (DeviceDriverFactory)driverFactory, lds, (boolean)false, (boolean)false, (boolean)attachLanDeviceParams, null, null));
        }
        return dto;
    }

    public static List<GatewayClient> toDTOs(List<GatewayClientEntity> gatewayClients, GatewayDeviceConnectionService gatewayDeviceConnection, DeviceDriverFactory driverFactory, boolean attachLanDevices, boolean attachLanDeviceParams) {
        ArrayList<GatewayClient> dtos = new ArrayList<GatewayClient>();
        for (GatewayClientEntity gatewayClient : gatewayClients) {
            dtos.add(gatewayClient.toDTO(gatewayDeviceConnection, driverFactory, attachLanDevices, attachLanDeviceParams));
        }
        return dtos;
    }
}

