/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.main;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import pl.smartapps.restserver.util.MacAddressRange;
import pl.smartapps.restserver.util.Version;

@Entity
@Table(name="firmware")
@NamedQueries(value={@NamedQuery(name="FirmwareEntity.FIND_ALL", query="select f from FirmwareEntity f")})
public class FirmwareEntity
implements Serializable {
    private static final long serialVersionUID = -5484043175922265439L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="firmware_seq")
    @SequenceGenerator(name="firmware_seq", sequenceName="firmware_seq", allocationSize=1)
    @Basic(optional=false)
    @Column(name="firmware_id")
    private Integer firmawareId;
    @Basic(optional=false)
    @Column(name="class")
    private String deviceClass;
    @Basic(optional=false)
    @Column(name="vendor")
    private String vendor;
    @Basic(optional=false)
    @Column(name="model")
    private String model;
    @Basic(optional=false)
    @Column(name="domain")
    private String domain;
    @Basic(optional=false)
    @Column(name="version")
    private String version;
    @Basic(optional=false)
    @Column(name="url")
    private String url;
    @Basic(optional=false)
    @Column(name="md5")
    private String md5;
    @Basic(optional=true)
    @Column(name="mac_from")
    private String macFrom;
    @Basic(optional=true)
    @Column(name="mac_to")
    private String macTo;

    public Integer getFirmawareId() {
        return this.firmawareId;
    }

    public void setFirmawareId(Integer firmawareId) {
        this.firmawareId = firmawareId;
    }

    public String getDeviceClass() {
        return this.deviceClass;
    }

    public void setDeviceClass(String deviceClass) {
        this.deviceClass = deviceClass;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public boolean isNewer(FirmwareEntity other) {
        return new Version(this.version).compareTo(new Version(other.version)) > 0;
    }

    public boolean isInRange(String mac) {
        return this.getRange().contains(mac);
    }

    private MacAddressRange getRange() {
        String min = this.macFrom == null ? "00:00:00:00:00:00" : this.macFrom;
        String max = this.macTo == null ? "FF:FF:FF:FF:FF:FF" : this.macTo;
        return new MacAddressRange(min, max);
    }
}

