/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.main;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import pl.smartapps.hm.WebViewer.shared.model.Eventlog;

@Entity
@Table(name="eventlog")
public class EventlogEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="eventlog_seq")
    @SequenceGenerator(name="eventlog_seq", sequenceName="eventlog_seq", allocationSize=1)
    @Basic(optional=false)
    @Column(name="event_id")
    private Integer eventId;
    @Basic(optional=false)
    @Column(name="source")
    private String source;
    @Basic(optional=true)
    @Column(name="source_mac")
    private String sourceMac;
    @Basic(optional=true)
    @Column(name="source_ip")
    private String sourceIp;
    @Basic(optional=false)
    @Column(name="event_type")
    private String eventType;
    @Basic(optional=false)
    @Column(name="timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date timestamp;
    @Column(name="status")
    private String status;
    @Column(name="description")
    private String description;

    public EventlogEntity() {
    }

    public EventlogEntity(Integer eventId) {
        this.eventId = eventId;
    }

    public EventlogEntity(Integer eventId, String source, String sourceMac, String sourceIp, String eventType, Date timestamp) {
        this.eventId = eventId;
        this.source = source;
        this.sourceMac = sourceMac;
        this.sourceIp = sourceIp;
        this.eventType = eventType;
        this.timestamp = timestamp;
    }

    public Integer getEventId() {
        return this.eventId;
    }

    public void setEventId(Integer eventId) {
        this.eventId = eventId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSourceMac() {
        return this.sourceMac;
    }

    public void setSourceMac(String sourceMac) {
        this.sourceMac = sourceMac;
    }

    public String getSourceIp() {
        return this.sourceIp;
    }

    public void setSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.eventId != null ? this.eventId.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EventlogEntity)) {
            return false;
        }
        EventlogEntity other = (EventlogEntity)object;
        return (this.eventId != null || other.eventId == null) && (this.eventId == null || this.eventId.equals(other.eventId));
    }

    public String toString() {
        return "Eventlog[eventId=" + this.eventId + "]";
    }

    public String dump() {
        return "EventlogEntity [eventId=" + this.eventId + ", source=" + this.source + ", sourceMac=" + this.sourceMac + ", sourceIp=" + this.sourceIp + ", eventType=" + this.eventType + ", timestamp=" + this.timestamp + ", status=" + this.status + ", description=" + this.description + "]";
    }

    public Eventlog toDTO() {
        Eventlog dto = new Eventlog();
        dto.setEventId(this.eventId);
        dto.setSource(this.source);
        dto.setSourceMac(this.sourceMac);
        dto.setSourceIp(this.sourceIp);
        dto.setEventType(this.eventType);
        dto.setTimestamp(this.timestamp);
        dto.setStatus(this.status);
        dto.setDescription(this.description);
        return dto;
    }

    public static List<Eventlog> toDTOs(List<EventlogEntity> eventlogs) {
        if (eventlogs == null || eventlogs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Eventlog> dtos = new ArrayList<Eventlog>(eventlogs.size());
        for (EventlogEntity eventlog : eventlogs) {
            dtos.add(eventlog.toDTO());
        }
        return dtos;
    }
}

