/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.main;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import pl.smartapps.hm.WebViewer.shared.model.Event;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.impl.EventServiceImpl;

@Entity
@Table(name="event")
public class EventEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="event_seq")
    @SequenceGenerator(name="event_seq", sequenceName="event_seq", allocationSize=1)
    @Basic(optional=false)
    @Column(name="event_id")
    private Integer eventId;
    @Basic(optional=false)
    @Column(name="date_event")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateEvent;
    @Column(name="date_start_requested")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateStartRequested;
    @Column(name="date_started")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateStarted;
    @Column(name="date_stopped")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateStopped;
    @Column(name="date_stop_requested")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateStopRequested;
    @Basic(optional=false)
    @Column(name="eventtrigger")
    @Enumerated(value=EnumType.STRING)
    private EventServiceImpl.EventTrigger eventtrigger;
    @Column(name="video_file_size")
    private Integer videoFileSize;
    @Basic(optional=false)
    @Column(name="deleted_video")
    private boolean deletedVideo;
    @Basic(optional=false)
    @Column(name="deleted")
    private boolean deleted;
    @JoinColumn(name="landevice_id", referencedColumnName="landevice_id")
    @ManyToOne(optional=false)
    private LanDeviceEntity lanDevice;
    @Column(name="image_file_size")
    private Integer imageFileSize;
    @Column(name="deleted_video_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deletedVideoDate;

    public EventEntity() {
    }

    public EventEntity(Integer eventId) {
        this.eventId = eventId;
    }

    public EventEntity(Integer eventId, Date dateEvent, EventServiceImpl.EventTrigger eventtrigger, boolean deletedVideo, boolean deleted) {
        this.eventId = eventId;
        this.dateEvent = dateEvent;
        this.eventtrigger = eventtrigger;
        this.deletedVideo = deletedVideo;
        this.deleted = deleted;
    }

    public Integer getEventId() {
        return this.eventId;
    }

    public void setEventId(Integer eventId) {
        this.eventId = eventId;
    }

    public Date getDateEvent() {
        return this.dateEvent;
    }

    public void setDateEvent(Date dateEvent) {
        this.dateEvent = dateEvent;
    }

    public Date getDateStartRequested() {
        return this.dateStartRequested;
    }

    public void setDateStartRequested(Date dateStartRequested) {
        this.dateStartRequested = dateStartRequested;
    }

    public Date getDateStarted() {
        return this.dateStarted;
    }

    public void setDateStarted(Date dateStarted) {
        this.dateStarted = dateStarted;
    }

    public Date getDateStopped() {
        return this.dateStopped;
    }

    public void setDateStopped(Date dateStopped) {
        this.dateStopped = dateStopped;
    }

    public Date getDateStopRequested() {
        return this.dateStopRequested;
    }

    public void setDateStopRequested(Date dateStopRequested) {
        this.dateStopRequested = dateStopRequested;
    }

    public EventServiceImpl.EventTrigger getEventtrigger() {
        return this.eventtrigger;
    }

    public void setEventtrigger(EventServiceImpl.EventTrigger eventtrigger) {
        this.eventtrigger = eventtrigger;
    }

    public Integer getVideoFileSize() {
        return this.videoFileSize;
    }

    public void setVideoFileSize(Integer videoFileSize) {
        this.videoFileSize = videoFileSize;
    }

    public boolean getDeletedVideo() {
        return this.deletedVideo;
    }

    public void setDeletedVideo(boolean deletedVideo) {
        this.deletedVideo = deletedVideo;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public LanDeviceEntity getLanDevice() {
        return this.lanDevice;
    }

    public void setLanDevice(LanDeviceEntity lanDevice) {
        this.lanDevice = lanDevice;
    }

    public Integer getImageFileSize() {
        return this.imageFileSize;
    }

    public void setImageFileSize(Integer imageFileSize) {
        this.imageFileSize = imageFileSize;
    }

    public Date getDeletedVideoDate() {
        return this.deletedVideoDate;
    }

    public void setDeletedVideoDate(Date deletedVideoDate) {
        this.deletedVideoDate = deletedVideoDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateEvent == null ? 0 : this.dateEvent.hashCode());
        result = 31 * result + (this.dateStartRequested == null ? 0 : this.dateStartRequested.hashCode());
        result = 31 * result + (this.dateStarted == null ? 0 : this.dateStarted.hashCode());
        result = 31 * result + (this.dateStopRequested == null ? 0 : this.dateStopRequested.hashCode());
        result = 31 * result + (this.dateStopped == null ? 0 : this.dateStopped.hashCode());
        result = 31 * result + (this.deleted ? 1231 : 1237);
        result = 31 * result + (this.deletedVideo ? 1231 : 1237);
        result = 31 * result + (this.eventId == null ? 0 : this.eventId.hashCode());
        result = 31 * result + (this.eventtrigger == null ? 0 : this.eventtrigger.hashCode());
        result = 31 * result + (this.imageFileSize == null ? 0 : this.imageFileSize.hashCode());
        result = 31 * result + (this.lanDevice == null ? 0 : this.lanDevice.hashCode());
        result = 31 * result + (this.videoFileSize == null ? 0 : this.videoFileSize.hashCode());
        result = 31 * result + (this.deletedVideoDate == null ? 0 : this.deletedVideoDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventEntity other = (EventEntity)obj;
        if (this.dateEvent == null ? other.dateEvent != null : !this.dateEvent.equals(other.dateEvent)) {
            return false;
        }
        if (this.dateStartRequested == null ? other.dateStartRequested != null : !this.dateStartRequested.equals(other.dateStartRequested)) {
            return false;
        }
        if (this.dateStarted == null ? other.dateStarted != null : !this.dateStarted.equals(other.dateStarted)) {
            return false;
        }
        if (this.dateStopRequested == null ? other.dateStopRequested != null : !this.dateStopRequested.equals(other.dateStopRequested)) {
            return false;
        }
        if (this.dateStopped == null ? other.dateStopped != null : !this.dateStopped.equals(other.dateStopped)) {
            return false;
        }
        if (this.deleted != other.deleted) {
            return false;
        }
        if (this.deletedVideo != other.deletedVideo) {
            return false;
        }
        if (this.eventId == null ? other.eventId != null : !this.eventId.equals(other.eventId)) {
            return false;
        }
        if (this.eventtrigger == null ? other.eventtrigger != null : !this.eventtrigger.equals((Object)other.eventtrigger)) {
            return false;
        }
        if (this.imageFileSize == null ? other.imageFileSize != null : !this.imageFileSize.equals(other.imageFileSize)) {
            return false;
        }
        if (this.lanDevice == null ? other.lanDevice != null : !this.lanDevice.equals((Object)other.lanDevice)) {
            return false;
        }
        if (this.videoFileSize == null ? other.videoFileSize != null : !this.videoFileSize.equals(other.videoFileSize)) {
            return false;
        }
        return !(this.deletedVideoDate == null ? other.deletedVideoDate != null : !this.deletedVideoDate.equals(other.deletedVideoDate));
    }

    public String toString() {
        return "EventEntity [eventId=" + this.eventId + "]";
    }

    public String dump() {
        return "EventEntity [eventId=" + this.eventId + ", dateEvent=" + this.dateEvent + ", dateStartRequested=" + this.dateStartRequested + ", dateStarted=" + this.dateStarted + ", dateStopped=" + this.dateStopped + ", dateStopRequested=" + this.dateStopRequested + ", eventtrigger=" + this.eventtrigger + ", videoFileSize=" + this.videoFileSize + ", deletedVideo=" + this.deletedVideo + ", deleted=" + this.deleted + ", imageFileSize=" + this.imageFileSize + ", deletedVideoDate=" + this.deletedVideoDate + "]";
    }

    public Event toDTO() {
        Event event = new Event();
        event.setEventId(this.eventId);
        event.setLanDeviceId(this.lanDevice.getLanDeviceId());
        event.setCameraName(this.lanDevice.getName());
        event.setDateEvent(this.dateEvent);
        event.setImageFileSize(this.imageFileSize);
        event.setEventTrigger(this.eventtrigger.toString());
        event.setDateStartRequested(this.dateStartRequested);
        event.setDateStarted(this.dateStarted);
        event.setDateStopRequested(this.dateStopRequested);
        event.setDateStopped(this.dateStopped);
        event.setDeletedVideo(Boolean.valueOf(this.deletedVideo));
        event.setDeletedVideoDate(this.deletedVideoDate);
        event.setDeleted(Boolean.valueOf(this.deleted));
        return event;
    }
}

