/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.main;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import pl.smartapps.hm.WebViewer.shared.model.DeviceDesc;
import pl.smartapps.restserver.db.main.LanDeviceEntity;

@Entity
@Table(name="devicedesc")
public class DeviceDescEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="devicedesc_seq")
    @SequenceGenerator(name="devicedesc_seq", sequenceName="devicedesc_seq", allocationSize=1)
    @Basic(optional=false)
    @Column(name="devicedesc_id")
    private Integer deviceDescId;
    @Basic(optional=false)
    @Column(name="class")
    private String classDevice;
    @Basic(optional=false)
    @Column(name="make")
    private String make;
    @Basic(optional=false)
    @Column(name="model")
    private String model;
    @Basic(optional=false)
    @Column(name="driverclass")
    private String driverclass;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="deviceDesc", fetch=FetchType.LAZY)
    private List<LanDeviceEntity> lanDevices;
    @Column(name="firmware_version")
    private String firmwareVersion;
    @Column(name="firmware_file")
    private String firmwareFile;
    @Column(name="drivercode")
    private String drivercode;

    public DeviceDescEntity() {
    }

    public DeviceDescEntity(Integer deviceDescId) {
        this.deviceDescId = deviceDescId;
    }

    public DeviceDescEntity(Integer deviceDescId, String classDevice, String make, String model, String driverclass) {
        this.deviceDescId = deviceDescId;
        this.classDevice = classDevice;
        this.make = make;
        this.model = model;
        this.driverclass = driverclass;
    }

    public DeviceDescEntity(DeviceDesc deviceDesc) {
        this.classDevice = deviceDesc.getClassDevice();
        this.deviceDescId = deviceDesc.getDeviceDescId();
        this.driverclass = deviceDesc.getDriverclass();
        this.make = deviceDesc.getMake();
        this.model = deviceDesc.getModel();
    }

    public Integer getDeviceDescId() {
        return this.deviceDescId;
    }

    public void setDeviceDescId(Integer deviceDescId) {
        this.deviceDescId = deviceDescId;
    }

    public String getClassDevice() {
        return this.classDevice;
    }

    public void setClassDevice(String classDevice) {
        this.classDevice = classDevice;
    }

    public String getMake() {
        return this.make;
    }

    public void setMake(String make) {
        this.make = make;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getDriverclass() {
        return this.driverclass;
    }

    public void setDriverclass(String driverclass) {
        this.driverclass = driverclass;
    }

    public List<LanDeviceEntity> getLanDevices() {
        return this.lanDevices;
    }

    public void setLanDevices(List<LanDeviceEntity> lanDevices) {
        this.lanDevices = lanDevices;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public String getFirmwareFile() {
        return this.firmwareFile;
    }

    public void setFirmwareFile(String firmwareFile) {
        this.firmwareFile = firmwareFile;
    }

    public String getDrivercode() {
        return this.drivercode;
    }

    public void setDrivercode(String drivercode) {
        this.drivercode = drivercode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classDevice == null ? 0 : this.classDevice.hashCode());
        result = 31 * result + (this.deviceDescId == null ? 0 : this.deviceDescId.hashCode());
        result = 31 * result + (this.driverclass == null ? 0 : this.driverclass.hashCode());
        result = 31 * result + (this.make == null ? 0 : this.make.hashCode());
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.firmwareFile == null ? 0 : this.firmwareFile.hashCode());
        result = 31 * result + (this.firmwareVersion == null ? 0 : this.firmwareVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceDescEntity other = (DeviceDescEntity)obj;
        if (this.classDevice == null ? other.classDevice != null : !this.classDevice.equals(other.classDevice)) {
            return false;
        }
        if (this.deviceDescId == null ? other.deviceDescId != null : !this.deviceDescId.equals(other.deviceDescId)) {
            return false;
        }
        if (this.driverclass == null ? other.driverclass != null : !this.driverclass.equals(other.driverclass)) {
            return false;
        }
        if (this.make == null ? other.make != null : !this.make.equals(other.make)) {
            return false;
        }
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.firmwareFile == null ? other.firmwareFile != null : !this.firmwareFile.equals(other.firmwareFile)) {
            return false;
        }
        return !(this.firmwareVersion == null ? other.firmwareVersion != null : !this.firmwareVersion.equals(other.firmwareVersion));
    }

    public String toString() {
        return "DeviceDesc [deviceDescId=" + this.deviceDescId + "]";
    }

    public String dump() {
        return "DeviceDesc [deviceDescId=" + this.deviceDescId + ", classDevice=" + this.classDevice + ", make=" + this.make + ", model=" + this.model + ", driverclass=" + this.driverclass + ", firmwareVersion=" + this.firmwareVersion + ", firmwareFile=" + this.firmwareFile + "]";
    }

    public DeviceDesc toDTO() {
        DeviceDesc dto = new DeviceDesc();
        dto.setClassDevice(this.classDevice);
        dto.setDeviceDescId(this.deviceDescId);
        dto.setDriverclass(this.driverclass);
        dto.setMake(this.make);
        dto.setModel(this.model);
        dto.setFirmwareVersion(this.firmwareVersion);
        dto.setFirmwareFile(this.firmwareFile);
        return dto;
    }

    public static List<DeviceDesc> toDTOs(List<DeviceDescEntity> deviceDescs) {
        ArrayList<DeviceDesc> dtos = new ArrayList<DeviceDesc>();
        for (DeviceDescEntity deviceDesc : deviceDescs) {
            dtos.add(deviceDesc.toDTO());
        }
        return dtos;
    }
}

