/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.util.ErrorMessages;

@Repository
public class UserDAO {
    private static Logger log = Logger.getLogger(UserDAO.class);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private JpaTransactionManager txManager;

    public UserEntity store(UserEntity user) {
        log.trace((Object)("start store(user=" + user + ")"));
        if (user == null) {
            log.error((Object)"Store null entity request");
            return null;
        }
        try {
            if (user.getId() != null) {
                return (UserEntity)this.em.merge((Object)user);
            }
            this.em.persist((Object)user);
            return user;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.STORE_ENTITY_EXCEPTION((Object)user, (Exception)ex));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public UserEntity createUser(UserEntity user) {
        block2: {
            log.debug((Object)("start createUser(" + user + ")"));
            try {
                this.em.persist((Object)user);
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception creating user: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return user;
    }

    public UserEntity createUserWithTransaction(UserEntity user) {
        log.debug((Object)("start createUser(" + user + ")"));
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("createUser transaction");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        UserEntity result = this.createUser(user);
        this.txManager.commit(status);
        return result;
    }

    public UserEntity findUserByName(String username) {
        UserEntity user;
        block3: {
            log.debug((Object)("start findUserByName(username=" + username + ")"));
            user = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ue from UserEntity ue ");
                inquiry.append("where ue.username = :username ");
                inquiry.append("and ue.deleted = 0");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("username", (Object)username);
                user = (UserEntity)query.getSingleResult();
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found user for name " + username));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding users by username=" + username + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return user;
    }

    public UserEntity findUserByEmailAddress(String emailAddress) throws RuntimeException {
        log.debug((Object)("start findUserByEmailAddress(emailAddress=" + emailAddress + ")"));
        UserEntity user = null;
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select ue from UserEntity ue ");
            inquiry.append("where ue.email = :emailAddress ");
            inquiry.append("and ue.deleted = 0 ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("emailAddress", (Object)emailAddress);
            user = (UserEntity)query.getSingleResult();
        }
        catch (NoResultException nre) {
            log.debug((Object)("Not found user for emailAddress=" + emailAddress));
        }
        catch (RuntimeException re) {
            log.error((Object)("Error finding user by emailAddress=" + emailAddress + ": " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            throw re;
        }
        return user;
    }

    public UserEntity findUserByUsernameAndEmailAddress(String username, String emailAddress) {
        UserEntity user;
        block3: {
            log.debug((Object)("start findUserByUsernameAndEmailAddress(username=" + username + ", emailAddress=" + emailAddress + ")"));
            user = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ue from UserEntity ue ");
                inquiry.append("where ue.username = :username ");
                inquiry.append("and ue.email = :emailAddress ");
                inquiry.append("and ue.deleted = 0 ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("username", (Object)username);
                query.setParameter("emailAddress", (Object)emailAddress);
                user = (UserEntity)query.getSingleResult();
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found user for emailAddress=" + emailAddress));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding user by emailAddress=" + emailAddress + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return user;
    }

    public UserEntity findUserByActivationCode(String activationCode) {
        UserEntity user;
        block3: {
            log.debug((Object)("start findUserByActivationCode(activationCode=" + activationCode + ")"));
            user = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ue from UserEntity ue ");
                inquiry.append("where ue.activationCode = :activationCode ");
                inquiry.append("and ue.deleted = 0 ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("activationCode", (Object)activationCode);
                user = (UserEntity)query.getSingleResult();
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found user for activationCode=" + activationCode));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding user by activationCode=" + activationCode + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return user;
    }

    public UserEntity findUserByChangePasswordCode(String changePasswordCode) {
        UserEntity user;
        block3: {
            log.debug((Object)("start findUserByChangePasswordCode(changePasswordCode=" + changePasswordCode + ")"));
            user = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ue from UserEntity ue ");
                inquiry.append("where ue.changePasswordCode = :changePasswordCode ");
                inquiry.append("and ue.deleted = 0 ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("changePasswordCode", (Object)changePasswordCode);
                user = (UserEntity)query.getSingleResult();
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found user for changePasswordCode=" + changePasswordCode));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding user by changePasswordCode=" + changePasswordCode + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return user;
    }

    public UserEntity findUserById(Integer id) {
        return this.findUserById(id, false, false, false);
    }

    public UserEntity findUserById(Integer id, boolean fetchLanDevices, boolean fetchGatewayClients) {
        return this.findUserById(id, fetchLanDevices, fetchGatewayClients, false);
    }

    public UserEntity findUserById(Integer id, boolean fetchLanDevices, boolean fetchGatewayClients, boolean fetchRoles) {
        block6: {
            log.debug((Object)("start findUserById(id=" + id + ")"));
            try {
                StringBuilder inquiry = new StringBuilder("select ue from UserEntity ue ");
                if (fetchLanDevices) {
                    inquiry.append("left outer join ue.lanDevices ");
                }
                if (fetchGatewayClients) {
                    inquiry.append("left outer join ue.gatewayClients ");
                }
                if (fetchRoles) {
                    inquiry.append("left join fetch ue.roles ");
                }
                inquiry.append("where  ue.id = :id");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("id", (Object)id);
                List users = query.getResultList();
                return users == null || users.isEmpty() ? null : (UserEntity)users.get(0);
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found user for id " + id));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding users by id=" + id + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block6;
                re.printStackTrace();
            }
        }
        return null;
    }

    public UserEntity updateUser(UserEntity user) {
        UserEntity mergedUser;
        block2: {
            log.debug((Object)("start updateUser: " + user));
            mergedUser = null;
            try {
                mergedUser = (UserEntity)this.em.merge((Object)user);
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception updating user: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return mergedUser;
    }

    public List<UserEntity> findAllUsers() {
        List users;
        block2: {
            log.debug((Object)"start findAllUsers()");
            users = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ue from UserEntity ue ");
                inquiry.append("order by ue.username ");
                Query query = this.em.createQuery(inquiry.toString());
                users = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding users: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("findAllUsers result size: " + users.size()));
        return users;
    }

    public List<UserEntity> findUsers(boolean active, boolean deleted) {
        List users;
        block6: {
            log.debug((Object)("start findUsers(active=" + active + ", deleted=" + deleted + ")"));
            if (!active && !deleted) {
                return Collections.emptyList();
            }
            users = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ue from UserEntity ue ");
                if (active && !deleted) {
                    inquiry.append("where ue.deleted = 0 ");
                } else if (!active && deleted) {
                    inquiry.append("where ue.deleted <> 0 ");
                }
                inquiry.append("order by ue.username ");
                Query query = this.em.createQuery(inquiry.toString());
                users = query.getResultList();
            }
            catch (RuntimeException re) {
                log.warn((Object)("Error occured finding users: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block6;
                re.printStackTrace();
            }
        }
        log.debug((Object)("end findUsers(active=" + active + ", deleted=" + deleted + "). Result size: " + users.size() + "."));
        return users;
    }

    public List<UserEntity> findUsers() {
        List users;
        block2: {
            log.debug((Object)"start findUsers()");
            users = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ue from UserEntity ue ");
                inquiry.append("where ue.deleted = 0 ");
                inquiry.append("order by ue.username ");
                Query query = this.em.createQuery(inquiry.toString());
                users = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding users: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("findUsers result size: " + users.size()));
        return users;
    }

    public UserEntity getUserDetailsByName(String username) {
        UserEntity user;
        block3: {
            log.debug((Object)("start getUserDetailsByName(username=" + username + ")"));
            user = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ue from UserEntity ue ");
                inquiry.append("left join fetch ue.lanDevices as device ");
                inquiry.append("left join fetch ue.gatewayClients as client ");
                inquiry.append("left join fetch client.lanDevices as gcDevice ");
                inquiry.append("where  ue.username = :username ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("username", (Object)username);
                user = (UserEntity)query.getSingleResult();
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found user for username " + username));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding users by username=" + username + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return user;
    }

    public Long countRegistredUsers() {
        Long result;
        block2: {
            log.debug((Object)"start countRegistredUsers()");
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select count(ue) from UserEntity ue ");
                inquiry.append("where ue.deleted = 0 ");
                Query query = this.em.createQuery(inquiry.toString());
                result = (Long)query.getSingleResult();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting registered users: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit countRegistredUsers(): " + result));
        return result;
    }

    public List<Object[]> getUserRegistrationsPerDay(Date dateFrom, Date dateTo) {
        List result;
        block8: {
            log.debug((Object)("start getUserRegistrationsPerDay(dateFrom=" + dateFrom + ", dateTo=" + dateTo + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select date_date, count(id) from user ");
                inquiry.append("right outer join reportingdate on date_date = date(added_date) ");
                inquiry.append("where ");
                if (dateFrom == null) {
                    inquiry.append("date_date >= date((select min(added_date) from user)) ");
                } else {
                    inquiry.append("date_date >= :dateFrom ");
                }
                if (dateTo == null) {
                    inquiry.append(" and date_date <= date(now()) ");
                } else {
                    inquiry.append(" and date_date <= :dateTo ");
                }
                inquiry.append("group by date_date ");
                Query query = this.em.createNativeQuery(inquiry.toString());
                if (dateFrom != null) {
                    query.setParameter("dateFrom", (Object)dateFrom);
                }
                if (dateTo != null) {
                    query.setParameter("dateTo", (Object)dateTo);
                }
                result = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting registered users per day: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block8;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit getUserRegistrationsPerDay(): " + (result == null ? null : Integer.valueOf(result.size()))));
        return result;
    }

    public List<Object[]> getCumulatedUserRegistrationsPerDay(Date dateFrom, Date dateTo) {
        List result;
        block4: {
            log.debug((Object)("start getCumulatedUserRegistrationsPerDay(dateFrom=" + dateFrom + ", dateTo=" + dateTo + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select d.date_date, count(*) from reportingdate d, user u ");
                inquiry.append("where d.date_date >= date(u.added_date) and d.date_date <= date(now() - interval 1 day) ");
                if (dateFrom != null && dateTo != null) {
                    inquiry.append("and d.date_date >= date(:dateFrom) and d.date_date <= date(:dateTo) ");
                }
                inquiry.append("group by d.date_date ");
                Query query = this.em.createNativeQuery(inquiry.toString());
                if (dateFrom != null && dateTo != null) {
                    query.setParameter("dateFrom", (Object)dateFrom);
                    query.setParameter("dateTo", (Object)dateTo);
                }
                result = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting cumulated registered users per day: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block4;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit getCumulatedUserRegistrationsPerDay(): " + (result == null ? null : Integer.valueOf(result.size()))));
        return result;
    }

    public List<UserEntity> findUsersByName(String name, boolean fetchDeleted) {
        List users;
        block4: {
            log.debug((Object)("start findUsersByName(name=" + name + ", fetchDeleted=" + fetchDeleted + ")"));
            users = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ue from UserEntity ue ");
                inquiry.append("where ue.username like lower(:name) ");
                if (!fetchDeleted) {
                    inquiry.append("and ue.deleted = 0 ");
                }
                inquiry.append("order by ue.username ");
                Query query = this.em.createQuery(inquiry.toString());
                if (name != null && !name.isEmpty()) {
                    query.setParameter("name", (Object)("%" + name.toLowerCase() + "%"));
                }
                users = query.getResultList();
            }
            catch (RuntimeException re) {
                log.warn((Object)("Failed to findUsersByName(name=" + name + ", fetchDeleted=" + fetchDeleted + "): " + re.getMessage()));
                if (!log.isDebugEnabled()) break block4;
                re.printStackTrace();
            }
        }
        log.debug((Object)("end findUsersByName(name=" + name + ", fetchDeleted=" + fetchDeleted + "). Result size: " + (users == null ? "null" : Integer.valueOf(users.size())) + "."));
        return users;
    }

    public List<UserEntity> findUsers(boolean fetchDeleted) {
        List users;
        block3: {
            log.debug((Object)("start findUsers(fetchDeleted=" + fetchDeleted + ")"));
            users = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ue from UserEntity ue ");
                if (!fetchDeleted) {
                    inquiry.append("where ue.deleted = 0 ");
                }
                inquiry.append("order by ue.username ");
                Query query = this.em.createQuery(inquiry.toString());
                users = query.getResultList();
            }
            catch (RuntimeException re) {
                log.warn((Object)("Failed to findUsers(fetchDeleted=" + fetchDeleted + "): " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        log.debug((Object)("end findUsers(fetchDeleted=" + fetchDeleted + "). Result size: " + (users == null ? "null" : Integer.valueOf(users.size())) + "."));
        return users;
    }

    public Integer getMaxDeletedValueByUsername(String username) {
        block3: {
            log.debug((Object)("start getMaxDeletedValueByUsername(username=" + username + ")"));
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select max(ue.deleted) from UserEntity ue ");
                inquiry.append("where ue.username = :username ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("username", (Object)username);
                return (Integer)query.getSingleResult();
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found max deleted value for username=" + username + ": " + nre.getMessage()));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding max deleted value by username=" + username + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return null;
    }

    public UserEntity findUserBySsoId(String ssoId) {
        UserEntity user;
        block3: {
            log.debug((Object)("start findUserBySsoId(ssoId=" + ssoId + ")"));
            user = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ue from UserEntity ue ");
                inquiry.append("where ue.ssoId = :ssoId ");
                inquiry.append("and ue.deleted = 0");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("ssoId", (Object)ssoId);
                user = (UserEntity)query.getSingleResult();
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found user for ssoId " + ssoId));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding users by ssoId=" + ssoId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return user;
    }

    public UserEntity findUserBySsoIdAndSsoServiceName(String ssoId, String ssoName) {
        UserEntity user;
        block3: {
            log.debug((Object)("start findUserBySsoIdAndServiceName(ssoId=" + ssoId + ", serviceName=" + ssoName + ")"));
            user = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ue from UserEntity ue ");
                inquiry.append("where ue.ssoId = :ssoId ");
                inquiry.append("and ue.ssoService.name = :ssoName ");
                inquiry.append("and ue.deleted = 0");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("ssoId", (Object)ssoId);
                query.setParameter("ssoName", (Object)ssoName);
                user = (UserEntity)query.getSingleResult();
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found user for ssoId " + ssoId + " and name " + ssoName));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding users by ssoId=" + ssoId + " and name=" + ssoName + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        log.debug((Object)("finish findUserBySsoIdAndServiceName(ssoId=" + ssoId + ", serviceName=" + ssoName + ") user = " + (user != null ? user.toString() : null)));
        return user;
    }

    public UserEntity geUserByDeviceId(Integer deviceId) {
        log.trace((Object)("start getUserByDeviceId(deviceId=" + deviceId + ")"));
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select ld.user from LanDeviceEntity ld where ld.lanDeviceId = :deviceId");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("deviceId", (Object)deviceId);
            return (UserEntity)query.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
        catch (RuntimeException re) {
            log.error((Object)("Error finding user for device with lanDeviceId=" + deviceId + ": " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return null;
        }
    }

    public UserEntity getUserById(Integer id) {
        if (id == null) {
            log.error((Object)ErrorMessages.FIND_BY_NULL_ID_REQUEST);
            return null;
        }
        try {
            TypedQuery query = this.em.createNamedQuery("UserEntity.FIND_BY_ID", UserEntity.class);
            query.setParameter("id", (Object)id);
            return (UserEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"UserEntity.FIND_BY_ID", (String)"select u from UserEntity u where u.id = :id", (Exception)ex));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }
}

