/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;
import pl.smartapps.restserver.db.main.TransactionEntity;
import pl.smartapps.restserver.util.Utils;

@Repository
public class TransactionDAO {
    private static Logger log = Logger.getLogger(TransactionDAO.class);
    @PersistenceContext
    private EntityManager em;

    public TransactionEntity createTransaction(TransactionEntity transaction) {
        block2: {
            log.debug((Object)("start createTransaction(transaction=" + transaction + ")"));
            try {
                this.em.persist((Object)transaction);
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception creating transaction: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return transaction;
    }

    public TransactionEntity updateTransaction(TransactionEntity transaction) {
        log.debug((Object)("start updateTransaction(transaction=" + transaction + ")"));
        try {
            return (TransactionEntity)this.em.merge((Object)transaction);
        }
        catch (RuntimeException re) {
            log.error((Object)("Exception updating transaction: " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return null;
        }
    }

    public TransactionEntity findTransactionById(Integer transactionId) {
        TransactionEntity transaction;
        block4: {
            log.debug((Object)("start findTransactionById(findTransactionById=" + transactionId + ")"));
            transaction = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select t from TransactionEntity t ");
                inquiry.append("where t.transactionId = :transactionId ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("transactionId", (Object)transactionId);
                transaction = (TransactionEntity)query.getSingleResult();
            }
            catch (NonUniqueResultException nure) {
                log.error((Object)("Found more than one transaction for transactionId=" + transactionId));
            }
            catch (NoResultException nre) {
                log.info((Object)("No transaction found for transactionId=" + transactionId));
            }
            catch (IllegalStateException ise) {
                log.error((Object)("Exception occured finding transaction for transactionId=" + transactionId));
                if (!log.isDebugEnabled()) break block4;
                ise.printStackTrace();
            }
        }
        log.debug((Object)("exit findTransactionById(findTransactionById=" + transactionId + "): " + transaction + "."));
        return transaction;
    }

    public TransactionEntity findTransactionByIdAndTimestamp(Integer transactionId, Date timestamp) {
        TransactionEntity transaction;
        block4: {
            log.debug((Object)("start findTransactionByIdAndTimestamp(transactionId=" + transactionId + ", timestamp=" + timestamp + ")"));
            transaction = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select t from TransactionEntity t ");
                inquiry.append("where t.transactionId = :transactionId ");
                inquiry.append("and t.timestamp = :timestamp ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("transactionId", (Object)transactionId);
                query.setParameter("timestamp", (Object)timestamp);
                transaction = (TransactionEntity)query.getSingleResult();
            }
            catch (NonUniqueResultException nure) {
                log.error((Object)("Found more than one transaction for transactionId=" + transactionId + " and timestamp=" + timestamp + "."));
            }
            catch (NoResultException nre) {
                log.info((Object)("No transaction found for transactionId=" + transactionId + " and timestamp=" + timestamp + "."));
            }
            catch (IllegalStateException ise) {
                log.error((Object)("Exception occured finding transaction for transactionId=" + transactionId + " and timestamp=" + timestamp + "."));
                if (!log.isDebugEnabled()) break block4;
                ise.printStackTrace();
            }
        }
        log.debug((Object)("exit findTransactionByIdAndTimestamp(transactionId=" + transactionId + ", timestamp=" + timestamp + "): " + transaction + "."));
        return transaction;
    }

    public List<TransactionEntity> findTransactions(Integer userId, Date dateFrom, Date dateTo, String status) {
        List transactions;
        block13: {
            log.debug((Object)("start findTransactions(userId=" + userId + ", dateFrom=" + dateFrom + ", dateTo=" + dateTo + ", status=" + status + ")"));
            transactions = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select t from TransactionEntity t ");
                ArrayList<String> whereElements = new ArrayList<String>();
                if (userId != null) {
                    whereElements.add("t.user.id = :userId ");
                }
                if (dateFrom != null) {
                    whereElements.add("t.timestamp >= :dateFrom ");
                }
                if (dateTo != null) {
                    whereElements.add("t.timestamp <= :dateTo ");
                }
                if (status != null) {
                    whereElements.add("t.status like lower(:status) ");
                }
                if (!whereElements.isEmpty()) {
                    inquiry.append("where ");
                    boolean firstWhere = true;
                    for (String whereElement : whereElements) {
                        if (firstWhere) {
                            inquiry.append(whereElement);
                            firstWhere = false;
                            continue;
                        }
                        inquiry.append("and ").append(whereElement);
                    }
                }
                inquiry.append("order by t.timestamp desc ");
                Query query = this.em.createQuery(inquiry.toString());
                if (userId != null) {
                    query.setParameter("userId", (Object)userId);
                }
                if (dateFrom != null) {
                    query.setParameter("dateFrom", Utils.adjustTime((Date)dateFrom, (int)0, (int)0, (int)0, (int)0), TemporalType.TIMESTAMP);
                }
                if (dateTo != null) {
                    query.setParameter("dateTo", Utils.adjustTime((Date)dateTo, (int)23, (int)59, (int)59, (int)999), TemporalType.TIMESTAMP);
                }
                if (status != null) {
                    query.setParameter("status", (Object)("%" + status + "%"));
                }
                transactions = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error getting transaction for userId=" + userId + ", dateFrom=" + dateFrom + ", dateTo=" + dateTo + ", status=" + status + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block13;
                re.printStackTrace();
            }
        }
        log.debug((Object)("end findTransactions(userId=" + userId + ", dateFrom=" + dateFrom + ", dateTo=" + dateTo + ", status=" + status + "): result size: " + (transactions == null ? "null" : Integer.valueOf(transactions.size()))));
        return transactions;
    }

    public List<TransactionEntity> findTransactions(Date dateFrom, Date dateTo, String username, String status) {
        List transactions;
        block13: {
            log.debug((Object)("start findTransactions(, dateFrom=" + dateFrom + ", dateTo=" + dateTo + "username=" + username + ", status=" + status + ")"));
            transactions = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select t from TransactionEntity t ");
                ArrayList<String> whereElements = new ArrayList<String>();
                if (dateFrom != null) {
                    whereElements.add("t.timestamp >= :dateFrom ");
                }
                if (dateTo != null) {
                    whereElements.add("t.timestamp <= :dateTo ");
                }
                if (username != null) {
                    whereElements.add("t.user.username like lower(:username) ");
                }
                if (status != null) {
                    whereElements.add("t.status like lower(:status) ");
                }
                if (!whereElements.isEmpty()) {
                    inquiry.append("where ");
                    boolean firstWhere = true;
                    for (String whereElement : whereElements) {
                        if (firstWhere) {
                            inquiry.append(whereElement);
                            firstWhere = false;
                            continue;
                        }
                        inquiry.append("and ").append(whereElement);
                    }
                }
                inquiry.append("order by t.timestamp desc ");
                Query query = this.em.createQuery(inquiry.toString());
                if (dateFrom != null) {
                    query.setParameter("dateFrom", Utils.adjustTime((Date)dateFrom, (int)0, (int)0, (int)0, (int)0), TemporalType.TIMESTAMP);
                }
                if (dateTo != null) {
                    query.setParameter("dateTo", Utils.adjustTime((Date)dateTo, (int)23, (int)59, (int)59, (int)999), TemporalType.TIMESTAMP);
                }
                if (username != null) {
                    query.setParameter("username", (Object)("%" + username + "%"));
                }
                if (status != null) {
                    query.setParameter("status", (Object)("%" + status + "%"));
                }
                transactions = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error getting transaction for username=" + username + ", dateFrom=" + dateFrom + ", dateTo=" + dateTo + ", status=" + status + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block13;
                re.printStackTrace();
            }
        }
        log.debug((Object)("end findTransactions(username=" + username + ", dateFrom=" + dateFrom + ", dateTo=" + dateTo + ", status=" + status + "): result size: " + (transactions == null ? "null" : Integer.valueOf(transactions.size()))));
        return transactions;
    }
}

