/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;
import pl.smartapps.restserver.db.main.ShareEntity;

@Repository
public class ShareDAO {
    private static Logger log = Logger.getLogger(ShareDAO.class);
    @PersistenceContext
    private EntityManager em;

    public ShareEntity createShare(ShareEntity share) {
        block2: {
            log.debug((Object)("start createShare(share=" + share + ")"));
            try {
                this.em.persist((Object)share);
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception creating share: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return share;
    }

    public ShareEntity update(ShareEntity share) {
        ShareEntity mergedShare;
        block2: {
            log.debug((Object)("start update(share=" + share + ")"));
            mergedShare = null;
            try {
                mergedShare = (ShareEntity)this.em.merge((Object)share);
            }
            catch (Exception re) {
                log.error((Object)("Exception saving share: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return mergedShare;
    }

    public ShareEntity findShareByShareId(Integer shareId) {
        ShareEntity share;
        block3: {
            log.debug((Object)("start findShareByShareId(shareId=" + shareId + ")"));
            share = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select se from ShareEntity se ");
                inquiry.append("where se.shareId = :shareId ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("shareId", (Object)shareId);
                share = (ShareEntity)query.getSingleResult();
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found share for shareId=" + shareId + "."));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding share for shareId=" + shareId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        log.debug((Object)("start findShareByShareId(shareId=" + shareId + "): " + share));
        return share;
    }

    public List<ShareEntity> findSharesByEmail(String email) {
        List shares;
        block2: {
            log.debug((Object)("start findSharesByEmail(email=" + email + ")"));
            shares = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select se from ShareEntity se ");
                inquiry.append("where se.email = :email ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("email", (Object)email);
                shares = query.getResultList();
                log.debug((Object)("exit findSharesByEmail(email=" + email + "): " + shares.size()));
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding shares from email=" + email + "."));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return shares;
    }

    public ShareEntity findSharesByLanDeviceIdAndUserId(Integer lanDeviceId, Integer userId) {
        ShareEntity share;
        block2: {
            log.debug((Object)("start findSharesByLanDeviceIdAndUserId(lanDeviceId=" + lanDeviceId + ", userId=" + userId + ")"));
            share = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select se from ShareEntity se ");
                inquiry.append("where se.user.id = :userId ");
                inquiry.append("and se.lanDevice.lanDeviceId = :lanDeviceId ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                query.setParameter("lanDeviceId", (Object)lanDeviceId);
                share = (ShareEntity)query.getSingleResult();
                log.debug((Object)("exit findSharesByLanDeviceIdAndUserId(lanDeviceId=" + lanDeviceId + ", userId=" + userId + "): " + share));
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding shares for lanDeviceId=" + lanDeviceId + "and userId=" + userId + "."));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return share;
    }
}

