/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Repository;
import pl.smartapps.restserver.db.main.SSOServiceEntity;

@Repository
public class SSOServiceDAO {
    private static Logger log = Logger.getLogger(SSOServiceDAO.class);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private JpaTransactionManager txManager;

    public void detach(SSOServiceEntity ssoService) {
        this.em.detach((Object)ssoService);
    }

    public SSOServiceEntity findSSOServiceById(Integer ssoServiceId) {
        log.debug((Object)("start findSSOServiceById(" + ssoServiceId + ")"));
        SSOServiceEntity ssoService = null;
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select distinct ss from SSOServiceEntity ss ");
            inquiry.append("where ss.ssoSeviceId = :ssoServiceId ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("ssoServiceId", (Object)ssoServiceId);
            ssoService = (SSOServiceEntity)query.getSingleResult();
        }
        catch (NonUniqueResultException nure) {
            log.error((Object)("Found more than one sso service for id " + ssoServiceId));
        }
        catch (NoResultException nre) {
            log.error((Object)("Not found sso service for id " + ssoServiceId));
        }
        catch (IllegalStateException ise) {
            log.error((Object)("Exception occurred finding sso service for id " + ssoServiceId));
        }
        log.debug((Object)("finish findSSOServiceById(" + ssoServiceId + ") = " + ssoService.toString()));
        return ssoService;
    }

    public SSOServiceEntity findSSOServiceByName(String name) {
        log.debug((Object)("start findSSOServiceByName(" + name + ")"));
        SSOServiceEntity ssoService = null;
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select distinct ss from SSOServiceEntity ss ");
            inquiry.append("where ss.name = :name ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("name", (Object)name);
            ssoService = (SSOServiceEntity)query.getSingleResult();
        }
        catch (NonUniqueResultException nure) {
            log.error((Object)("Found more than one sso service for name " + name));
        }
        catch (NoResultException nre) {
            log.error((Object)("Not found sso service for name " + name));
        }
        catch (IllegalStateException ise) {
            log.error((Object)("Exception occurred finding sso service for name " + name));
        }
        log.debug((Object)("finish findSSOServiceByName(" + name + ") = " + ssoService.toString()));
        return ssoService;
    }

    public List<String> getAllSSONames() {
        List names;
        block2: {
            log.debug((Object)"start getAllSSONames");
            names = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select distinct ss.name from SSOServiceEntity ss ");
                Query query = this.em.createQuery(inquiry.toString());
                names = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)"Exception occured finding sso names");
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("finish getAllSSONames = " + (names != null ? names.toString() : null)));
        return names;
    }
}

