/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;
import pl.smartapps.restserver.db.main.SSOParameterEntity;

@Repository
public class SSOParameterDAO {
    private static Logger log = Logger.getLogger(SSOParameterDAO.class);
    @PersistenceContext
    private EntityManager em;

    public SSOParameterEntity findSSOParameter(String ssoName, String parameterName) {
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select sp from SSOServiceEntity ss, in(ss.parameters) sp ");
            inquiry.append("where ss.name = :ssoName ");
            inquiry.append("and sp.code = :parameterName ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("ssoName", (Object)ssoName);
            query.setParameter("parameterName", (Object)parameterName);
            return (SSOParameterEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            log.warn((Object)("Failed to get SSO parameter for ssoName=" + ssoName + " and parameterName=" + parameterName + ": " + ex.getMessage()));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }
}

