/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;
import pl.smartapps.restserver.db.dao.ProductDAO;
import pl.smartapps.restserver.db.main.ProductfeatureEntity;

@Repository
public class ProductFeatureDAO {
    private static Logger log = Logger.getLogger(ProductDAO.class);
    @PersistenceContext
    private EntityManager em;

    public ProductfeatureEntity findProductfeature(Integer productId, String featureCode) {
        ProductfeatureEntity productfeatre;
        block3: {
            log.debug((Object)("start findProductfeature(productId=" + productId + ", featureCode=" + featureCode + ")"));
            productfeatre = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select pf from ProductfeatureEntity pf ");
                inquiry.append("where pf.product.productId = :productId ");
                inquiry.append("and pf.feature.featureCode = :featureCode ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("productId", (Object)productId);
                query.setParameter("featureCode", (Object)featureCode);
                productfeatre = (ProductfeatureEntity)query.getSingleResult();
            }
            catch (NoResultException e) {
                log.debug((Object)("No productfeature found for productId=" + productId + " and featureCode=" + featureCode + "."));
            }
            catch (RuntimeException e) {
                log.warn((Object)("Error occured during finding productfeature for productId=" + productId + " and featureCode=" + featureCode + ": " + e.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
        log.debug((Object)("exit findProductfeature(productId=" + productId + ", featureCode=" + featureCode + "): " + productfeatre + "."));
        return productfeatre;
    }

    public ProductfeatureEntity findUserProductfeature(Integer userId, String featureCode) {
        ProductfeatureEntity productfeatre;
        block3: {
            log.debug((Object)("start findUserProductfeature(userId=" + userId + ", featureCode=" + featureCode + ")"));
            productfeatre = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select pf from UserEntity u, in(u.product.productfeatures) pf ");
                inquiry.append("where u.id = :userId ");
                inquiry.append("and pf.feature.featureCode = :featureCode ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                query.setParameter("featureCode", (Object)featureCode);
                productfeatre = (ProductfeatureEntity)query.getSingleResult();
            }
            catch (NoResultException e) {
                log.debug((Object)("No productfeature found for userId=" + userId + " and featureCode=" + featureCode + "."));
            }
            catch (RuntimeException e) {
                log.warn((Object)("Error occured during finding productfeature for userId=" + userId + " and featureCode=" + featureCode + ": " + e.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
        log.debug((Object)("exit findProductfeature(userId=" + userId + ", featureCode=" + featureCode + "): " + productfeatre + "."));
        return productfeatre;
    }

    public ProductfeatureEntity findDeviceProductfeature(Integer lanDeviceId, String featureCode) {
        ProductfeatureEntity productfeatre;
        block3: {
            log.debug((Object)("start findDeviceProductfeature(lanDeviceId=" + lanDeviceId + ", featureCode=" + featureCode + ")"));
            productfeatre = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select pf from LanDeviceEntity lde, in(lde.product.productfeatures) pf ");
                inquiry.append("where lde.lanDeviceId = :lanDeviceId ");
                inquiry.append("and pf.feature.featureCode = :featureCode ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("lanDeviceId", (Object)lanDeviceId);
                query.setParameter("featureCode", (Object)featureCode);
                productfeatre = (ProductfeatureEntity)query.getSingleResult();
            }
            catch (NoResultException e) {
                log.debug((Object)("No productfeature found for lanDeviceId=" + lanDeviceId + " and featureCode=" + featureCode + "."));
            }
            catch (RuntimeException e) {
                log.warn((Object)("Error occured during finding productfeature for lanDeviceId=" + lanDeviceId + " and featureCode=" + featureCode + ": " + e.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
        log.debug((Object)("exit findDeviceProductfeature(lanDeviceId=" + lanDeviceId + ", featureCode=" + featureCode + "): " + productfeatre + "."));
        return productfeatre;
    }
}

