/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import pl.smartapps.restserver.db.main.ProductEntity;

@Repository
public class ProductDAO {
    private static Logger log = Logger.getLogger(ProductDAO.class);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private JpaTransactionManager txManager;

    public ProductEntity findProductById(Integer productId) {
        ProductEntity product;
        block3: {
            log.debug((Object)("start findProductById(productId=" + productId + ")"));
            product = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select p from ProductEntity p ");
                inquiry.append("where p.productId = :productId ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("productId", (Object)productId);
                product = (ProductEntity)query.getSingleResult();
            }
            catch (NoResultException e) {
                log.debug((Object)("No product found for productId=" + productId + "."));
            }
            catch (RuntimeException e) {
                log.warn((Object)("Error occured during finding product for productId=" + productId + ": " + e.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
        log.debug((Object)("exit findProductById(productId=" + productId + "): " + product + "."));
        return product;
    }

    public ProductEntity findProductByIdWithTransaction(Integer productId) {
        log.debug((Object)("start findProductById(productId=" + productId + ")"));
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("findProductById transaction");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        ProductEntity result = this.findProductById(productId);
        this.txManager.commit(status);
        return result;
    }

    public ProductEntity findProductByName(String productName) {
        ProductEntity product;
        block3: {
            log.debug((Object)("start findProductByName(productName=" + productName + ")"));
            product = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select p from ProductEntity p ");
                inquiry.append("where p.name = :productName ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("productName", (Object)productName);
                product = (ProductEntity)query.getSingleResult();
            }
            catch (NoResultException e) {
                log.debug((Object)("No product found for productName=" + productName + "."));
            }
            catch (RuntimeException e) {
                log.warn((Object)("Error occured during finding product for productName=" + productName + ": " + e.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
        log.debug((Object)("exit findProductById(productName=" + productName + "): " + (product == null ? "null" : product.getProductId()) + "."));
        return product;
    }

    public ProductEntity findProductByCode(String productCode) {
        ProductEntity product;
        block3: {
            log.debug((Object)("start findProductByCode(productCode=" + productCode + ")"));
            product = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select p from ProductEntity p ");
                inquiry.append("where p.code = :productCode ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("productCode", (Object)productCode);
                product = (ProductEntity)query.getSingleResult();
            }
            catch (NoResultException e) {
                log.debug((Object)("No product found for productCode=" + productCode + "."));
            }
            catch (RuntimeException e) {
                log.warn((Object)("Error occured during finding product for productCode=" + productCode + ": " + e.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
        log.debug((Object)("exit findProductByCode(productCode=" + productCode + "): " + (product == null ? "null" : product.getProductId()) + "."));
        return product;
    }
}

