/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;
import pl.smartapps.restserver.db.main.ParameterEntity;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.util.ErrorMessages;
import pl.smartapps.restserver.util.ExceptionsTrigger;

@Repository
public class ParameterDAO {
    private static Logger log = Logger.getLogger(ParameterDAO.class);
    @PersistenceContext
    private EntityManager em;

    public ParameterEntity createParameter(ParameterEntity parameter) {
        block2: {
            log.trace((Object)("start createParameter(parameter=" + parameter + ")"));
            try {
                this.em.persist((Object)parameter);
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception creating parameter: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return parameter;
    }

    public ParameterEntity update(ParameterEntity parameter) {
        ParameterEntity mergedParameter;
        block2: {
            log.trace((Object)("start update(parameter=" + parameter + ")"));
            mergedParameter = null;
            try {
                mergedParameter = (ParameterEntity)this.em.merge((Object)parameter);
            }
            catch (Exception re) {
                log.error((Object)("Exception saving parameter: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return mergedParameter;
    }

    public ParameterEntity getParameter(ParameterService.ParameterCode code) {
        ExceptionsTrigger.throwIfNull((Object)code, (RuntimeException)new NullPointerException("code"));
        try {
            TypedQuery query = this.em.createNamedQuery("ParameterEntity.FIND_BY_CODE", ParameterEntity.class);
            query.setParameter("code", (Object)code.getCode());
            return (ParameterEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"ParameterEntity.FIND_BY_CODE", (String)"select p from ParameterEntity p where p.code =:code", (Exception)ex));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }
}

