/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;
import pl.smartapps.restserver.db.main.NotificationTokenEntity;
import pl.smartapps.restserver.util.ErrorMessages;
import pl.smartapps.restserver.util.Utils;

@Repository
public class NotificationTokenDAO {
    private static final Logger log = Logger.getLogger(NotificationTokenDAO.class);
    @PersistenceContext
    private EntityManager em;

    public NotificationTokenEntity store(NotificationTokenEntity entity) {
        if (entity == null) {
            log.error((Object)"Store null entity request");
            return null;
        }
        try {
            if (entity.getNotificationTokenId() != null) {
                return (NotificationTokenEntity)this.em.merge((Object)entity);
            }
            this.em.persist((Object)entity);
            return entity;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.STORE_ENTITY_EXCEPTION((Object)entity, (Exception)ex));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public NotificationTokenEntity getById(Integer id) {
        if (id != null) {
            return (NotificationTokenEntity)this.em.find(NotificationTokenEntity.class, (Object)id);
        }
        return null;
    }

    public NotificationTokenEntity getByToken(String token) {
        if (Utils.isBlank((String)token)) {
            throw new IllegalArgumentException("Blank tokn");
        }
        try {
            TypedQuery query = this.em.createNamedQuery("ApplicationEntity.FIND_BY_TOKEN", NotificationTokenEntity.class);
            query.setParameter("token", (Object)token);
            return (NotificationTokenEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"ApplicationEntity.FIND_BY_TOKEN", (String)"select n from NotificationTokenEntity n where n.token =:token", (Exception)ex));
            throw ex;
        }
    }

    public void remove(NotificationTokenEntity entity) {
        this.em.remove((Object)entity);
    }
}

