/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.util.ErrorMessages;
import pl.smartapps.restserver.util.ExceptionsTrigger;
import pl.smartapps.restserver.util.Utils;

@Repository
public class LanDeviceDAO {
    private static Logger log = Logger.getLogger(LanDeviceDAO.class);
    private DatabaseType databaseType;
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private JpaTransactionManager txManager;

    @Value(value="${database.url}")
    public void setDatabaseType(String databaseUrl) {
        if (Utils.isBlank((String)databaseUrl)) {
            throw new IllegalArgumentException("databaseUrl is blank");
        }
        if (databaseUrl.toLowerCase().startsWith("jdbc:mysql:")) {
            this.databaseType = DatabaseType.MYSQL;
        } else if (databaseUrl.toLowerCase().startsWith("jdbc:oracle:")) {
            this.databaseType = DatabaseType.ORACLE;
        } else {
            throw new IllegalArgumentException("unsupported database type");
        }
    }

    public LanDeviceEntity store(LanDeviceEntity entity) {
        if (entity == null) {
            log.error((Object)"Store null entity request");
            return null;
        }
        try {
            entity.dematerialize();
            if (entity.getLanDeviceId() != null) {
                LanDeviceEntity merged = (LanDeviceEntity)this.em.merge((Object)entity);
                merged.materialize();
                return merged;
            }
            this.em.persist((Object)entity);
            return entity;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.STORE_ENTITY_EXCEPTION((Object)entity, (Exception)ex));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public void detach(LanDeviceEntity lanDevice) {
        this.em.detach((Object)lanDevice);
    }

    public List<LanDeviceEntity> findLanDevicesByUserId(Integer userId, boolean fetchEvents) {
        return this.findLanDevicesByUserId(userId, fetchEvents, null);
    }

    public List<LanDeviceEntity> findLanDevicesByUserId(Integer userId, boolean fetchEvents, String deviceClass) {
        List lanDevices;
        block6: {
            log.debug((Object)("start findLanDevicesByUserId(userId=" + userId + ", fetchEvents=" + fetchEvents + ", deviceClass=" + deviceClass + ")"));
            lanDevices = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ld from LanDeviceEntity ld ");
                if (fetchEvents) {
                    inquiry.append("left join fetch ld.events ");
                }
                inquiry.append("where ld.user.id = :userId ");
                inquiry.append("and ld.deleted = false ");
                if (deviceClass != null) {
                    inquiry.append("and ld.deviceDesc.classDevice = :deviceClass ");
                }
                inquiry.append("order by ld.name ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                if (deviceClass != null) {
                    query.setParameter("deviceClass", (Object)deviceClass);
                }
                lanDevices = query.getResultList();
                for (LanDeviceEntity device : lanDevices) {
                    device.materialize();
                }
                log.debug((Object)("exit findLanDevicesByUserId(userId=" + userId + ", fetchEvents=" + fetchEvents + ", deviceClass=" + deviceClass + "): " + lanDevices.size()));
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding lan devices: " + re.getMessage() + "."));
                if (!log.isDebugEnabled()) break block6;
                re.printStackTrace();
            }
        }
        return lanDevices;
    }

    public List<LanDeviceEntity> findLanDevicesSharedWithUser(Integer userId, String deviceClass) {
        List lanDevices;
        block5: {
            log.debug((Object)("start findLanDevicesSharedWithUser(userId=" + userId + ", deviceClass=" + deviceClass + ")"));
            lanDevices = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ld from LanDeviceEntity ld, in(ld.shares) share ");
                inquiry.append("where ld.user.id <> :userId ");
                inquiry.append("and share.user.id = :userId ");
                inquiry.append("and ld.deleted = false ");
                if (deviceClass != null) {
                    inquiry.append("and ld.deviceDesc.classDevice = :deviceClass ");
                }
                inquiry.append("order by ld.name ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                if (deviceClass != null) {
                    query.setParameter("deviceClass", (Object)deviceClass);
                }
                lanDevices = query.getResultList();
                for (LanDeviceEntity device : lanDevices) {
                    device.materialize();
                }
                log.debug((Object)("exit findLanDevicesByUserId(userId=" + userId + "): " + lanDevices.size()));
            }
            catch (RuntimeException re) {
                log.error((Object)"Exception occured finding lan devices.");
                if (!log.isDebugEnabled()) break block5;
                re.printStackTrace();
            }
        }
        return lanDevices;
    }

    public List<LanDeviceEntity> findLanDevicesByGatewayClientIdAndUserId(Integer gcId, Integer userId) {
        List cameras;
        block3: {
            log.debug((Object)("start findLanDevicesByGatewayClientIdAndUserId(gcId=" + gcId + ", userId=" + userId + ")"));
            cameras = null;
            try {
                String inquiry = "select ld from LanDeviceEntity ld where ld.gatewayClient.gatewayClientId = :gcId and ld.gatewayClient.user.id = :userId and ld.user.id = :userId and ld.deleted = false";
                Query query = this.em.createQuery(inquiry);
                query.setParameter("gcId", (Object)gcId);
                query.setParameter("userId", (Object)userId);
                cameras = query.getResultList();
                for (LanDeviceEntity device : cameras) {
                    device.materialize();
                }
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding lan devices for gateway client id " + gcId + " and user id " + userId + "."));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return cameras;
    }

    public List<LanDeviceEntity> findLanDevicesByGatewayClientId(Integer gcId) {
        List devices;
        block3: {
            log.debug((Object)("start findLanDevicesByGatewayClientId(gcId=" + gcId + ")"));
            devices = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ld from LanDeviceEntity ld ");
                inquiry.append("where ld.gatewayClient.gatewayClientId = :gcId ");
                inquiry.append("and ld.deleted = false");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("gcId", (Object)gcId);
                devices = query.getResultList();
                for (LanDeviceEntity device : devices) {
                    device.materialize();
                }
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding lan devices for gateway client id " + gcId + "."));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return devices;
    }

    public LanDeviceEntity saveLanDevice(LanDeviceEntity lanDevice) {
        log.debug((Object)("start saveLanDevice(lanDevice=" + lanDevice.toString() + ")"));
        try {
            lanDevice.dematerialize();
            this.em.persist((Object)lanDevice);
        }
        catch (Exception re) {
            log.error((Object)("Exception saving lan device client: " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            lanDevice = null;
        }
        return lanDevice;
    }

    private GatewayClientEntity findGatewayClientById(Integer gatewayClientId) {
        log.debug((Object)("start findGatewayClientById(gatewayClientId=" + gatewayClientId + ")"));
        try {
            StringBuilder inquiry = new StringBuilder("select gc from GatewayClientEntity gc ");
            inquiry.append("where gc.gatewayClientId = :gatewayClientId");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("gatewayClientId", (Object)gatewayClientId);
            return (GatewayClientEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException re) {
            log.warn((Object)("Failed to find gateway client for gatewayClientId=" + gatewayClientId + ": " + re.getMessage()));
            throw re;
        }
    }

    public LanDeviceEntity saveLanDeviceWithTransaction(LanDeviceEntity lanDevice) {
        log.debug((Object)("start saveLanDeviceWithTransaction(lanDevice=" + lanDevice + "."));
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("saveLanDevice transaction");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        if (lanDevice.getGatewayClient().getGatewayClientId() != null) {
            GatewayClientEntity gce = lanDevice.getGatewayClient();
            GatewayClientEntity gc = this.findGatewayClientById(lanDevice.getGatewayClient().getGatewayClientId());
            gc.setActivationDate(gce.getActivationDate());
            gc.setBuildNo(gce.getBuildNo());
            gc.setConnectedDate(gce.getConnectedDate());
            gc.setDeleted(gce.getDeleted());
            gc.setDeviceType(gce.getDeviceType());
            gc.setDisconnectedDate(gce.getDisconnectedDate());
            gc.setDomainRecordId(gce.getDomainRecordId());
            gc.setLocalAddressDns(gce.getLocalAddressDns());
            gc.setLocalDomainRecordId(gce.getLocalDomainRecordId());
            gc.setLogConf(gce.getLogConf());
            gc.setMac(gce.getMac());
            gc.setModificationDate(gce.getModificationDate());
            gc.setName(gce.getName());
            gc.setSerialNumber(gce.getSerialNumber());
            gc.setUpnpAddress(gce.getUpnpAddress());
            gc.setUpnpPort(gce.getUpnpPort());
            gc.setUpnpReason(gce.getUpnpReason());
            gc.setUser(gce.getUser());
            gc.setVersion(gce.getVersion());
            lanDevice.setGatewayClient(gc);
        }
        LanDeviceEntity result = this.saveLanDevice(lanDevice);
        this.txManager.commit(status);
        return result;
    }

    public LanDeviceEntity updateLanDevice(LanDeviceEntity lanDevice) {
        LanDeviceEntity mergedLanDevice;
        block2: {
            log.debug((Object)("start updateLanDevice: " + lanDevice));
            mergedLanDevice = null;
            try {
                lanDevice.dematerialize();
                mergedLanDevice = (LanDeviceEntity)this.em.merge((Object)lanDevice);
                mergedLanDevice.materialize();
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception updating lan device: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return mergedLanDevice;
    }

    public LanDeviceEntity updateLanDeviceWithTransaction(LanDeviceEntity lanDevice) {
        log.debug((Object)("start updateLanDeviceWithTransaction(lanDevice=" + lanDevice + "."));
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("updateLanDevice transaction");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        LanDeviceEntity result = this.updateLanDevice(lanDevice);
        this.txManager.commit(status);
        return result;
    }

    public LanDeviceEntity findLanDeviceById(Integer lanDeviceId) {
        return this.findLanDeviceById(lanDeviceId, false, false, false);
    }

    public LanDeviceEntity findLanDeviceById(Integer lanDeviceId, boolean deleted) {
        return this.findLanDeviceById(lanDeviceId, false, false, deleted);
    }

    public LanDeviceEntity findLanDeviceById(Integer lanDeviceId, boolean fetchGatewayClient, boolean fetchDeviceDesc) {
        return this.findLanDeviceById(lanDeviceId, fetchGatewayClient, fetchDeviceDesc, false);
    }

    public LanDeviceEntity findLanDeviceById(Integer lanDeviceId, boolean fetchGatewayClient, boolean fetchDeviceDesc, boolean deleted) {
        return this.findLanDeviceById(lanDeviceId, fetchGatewayClient, fetchDeviceDesc, true, deleted);
    }

    public LanDeviceEntity findLanDeviceById(Integer lanDeviceId, boolean fetchGatewayClient, boolean fetchDeviceDesc, boolean fetchUser, boolean deleted) {
        log.debug((Object)("start findLanDeviceById(" + lanDeviceId + ")"));
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select distinct ld from LanDeviceEntity ld ");
            if (fetchGatewayClient) {
                inquiry.append("join fetch ld.gatewayClient as gc ");
            }
            if (fetchDeviceDesc) {
                inquiry.append("join fetch ld.deviceDesc as dd ");
            }
            if (fetchUser) {
                inquiry.append("join fetch ld.user as us ");
            }
            inquiry.append("where ld.lanDeviceId = :lanDeviceId ");
            inquiry.append("and ld.deleted = " + deleted + " ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("lanDeviceId", (Object)lanDeviceId);
            LanDeviceEntity lanDevice = (LanDeviceEntity)query.getSingleResult();
            lanDevice.materialize();
            return lanDevice;
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException re) {
            log.warn((Object)("Failed to find lan device for lanDeviceId=" + lanDeviceId + ": " + re.getMessage()));
            throw re;
        }
    }

    public LanDeviceEntity findLanDeviceByIdAndUserId(Integer lanDeviceId, Integer userId) {
        log.debug((Object)("start findLanDeviceByIdAndUserId(lanDeviceId=" + lanDeviceId + ", userId=" + userId + ")"));
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select ld from LanDeviceEntity ld ");
            inquiry.append("where ld.lanDeviceId = :lanDeviceId ");
            inquiry.append("and ld.deleted = false ");
            inquiry.append("and ld.user.id = :userId ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("lanDeviceId", (Object)lanDeviceId);
            query.setParameter("userId", (Object)userId);
            LanDeviceEntity lanDevice = (LanDeviceEntity)query.getSingleResult();
            lanDevice.materialize();
            return lanDevice;
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException re) {
            log.warn((Object)("Failed to find lan device for lanDeviceId=" + lanDeviceId + ": " + re.getMessage()));
            throw re;
        }
    }

    public boolean removeLanDevice(int lanDeviceId) {
        log.debug((Object)("start removeLanDevice(" + lanDeviceId + ")"));
        boolean result = true;
        try {
            LanDeviceEntity device = (LanDeviceEntity)this.em.find(LanDeviceEntity.class, (Object)lanDeviceId);
            if (device == null) {
                result = false;
            } else {
                this.em.remove((Object)device);
            }
        }
        catch (RuntimeException re) {
            log.error((Object)("Exception removing lan device for id " + lanDeviceId + ": " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            result = false;
        }
        return result;
    }

    public List<LanDeviceEntity> findAllLanDevicesByMac(String mac) {
        List lanDevices;
        block4: {
            log.debug((Object)("start findAllLanDevicesByMac(" + mac + ")"));
            if (mac == null || mac.trim().length() == 0) {
                return Collections.emptyList();
            }
            lanDevices = null;
            try {
                String inquiry = "select ld from LanDeviceEntity ld where ld.mac = :mac order by ld.addedDate desc";
                Query query = this.em.createQuery(inquiry);
                query.setParameter("mac", (Object)mac);
                lanDevices = query.getResultList();
                for (LanDeviceEntity device : lanDevices) {
                    device.materialize();
                }
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding all lan devices for mac " + mac + "."));
                if (!log.isDebugEnabled()) break block4;
                re.printStackTrace();
            }
        }
        return lanDevices;
    }

    public List<LanDeviceEntity> findAllLanDevices(Integer firstResult, Integer maxResult) {
        List lanDevices;
        block5: {
            log.debug((Object)("start findAllLanDevices(firstResult=" + firstResult + ", maxResult=" + maxResult + ")"));
            lanDevices = null;
            try {
                String inquiry = "select ld from LanDeviceEntity ld ";
                Query query = this.em.createQuery(inquiry);
                if (firstResult != null) {
                    query.setFirstResult(firstResult.intValue());
                }
                if (maxResult != null) {
                    query.setMaxResults(maxResult.intValue());
                }
                lanDevices = query.getResultList();
                for (LanDeviceEntity device : lanDevices) {
                    device.materialize();
                }
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding all lan devices: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block5;
                re.printStackTrace();
            }
        }
        return lanDevices;
    }

    public List<LanDeviceEntity> findNotDeletedLanDevices(Integer firstResult, Integer maxResult) {
        List lanDevices;
        block5: {
            log.debug((Object)("start findNotDeletedLanDevices(firstResult=" + firstResult + ", maxResult=" + maxResult + ")"));
            lanDevices = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ld from LanDeviceEntity ld ");
                inquiry.append("where ld.deleted = false ");
                Query query = this.em.createQuery(inquiry.toString());
                if (firstResult != null) {
                    query.setFirstResult(firstResult.intValue());
                }
                if (maxResult != null) {
                    query.setMaxResults(maxResult.intValue());
                }
                lanDevices = query.getResultList();
                for (LanDeviceEntity device : lanDevices) {
                    device.materialize();
                }
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding not deleted lan devices: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block5;
                re.printStackTrace();
            }
        }
        return lanDevices;
    }

    @Deprecated
    public LanDeviceEntity findLanDeviceByMac(String mac) {
        log.debug((Object)("start findLanDeviceByMac(mac=" + mac + ")"));
        if (mac == null || mac.trim().length() == 0) {
            return null;
        }
        try {
            String inquiry = "select ld from LanDeviceEntity ld where ld.mac = :mac";
            Query query = this.em.createQuery(inquiry);
            query.setParameter("mac", (Object)mac);
            LanDeviceEntity lanDevice = (LanDeviceEntity)query.getSingleResult();
            lanDevice.materialize();
            return lanDevice;
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException re) {
            log.warn((Object)("Failed to find lan device for mac=" + mac + ": " + re.getMessage()));
            throw re;
        }
    }

    public LanDeviceEntity findLanDevice(Integer lanDeviceId, Integer userId) {
        log.debug((Object)("start findLanDevice(lanDeviceId=" + lanDeviceId + ", userId=" + userId + ")"));
        if (lanDeviceId == null) {
            return null;
        }
        if (userId == null) {
            return null;
        }
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select ld from LanDeviceEntity ld ");
            inquiry.append("where ld.lanDeviceId = :lanDeviceId ");
            inquiry.append("and ld.user.id = :userId ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("lanDeviceId", (Object)lanDeviceId);
            query.setParameter("userId", (Object)userId);
            LanDeviceEntity lanDevice = (LanDeviceEntity)query.getSingleResult();
            lanDevice.materialize();
            return lanDevice;
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException re) {
            log.warn((Object)("Failed to find lan device for lanDeviceId=" + lanDeviceId + ": " + re.getMessage()));
            throw re;
        }
    }

    public LanDeviceEntity findNotDeletedLanDeviceByMac(String mac) {
        log.debug((Object)("start findNotDeletedLanDeviceByMac(mac=" + mac + ")"));
        ExceptionsTrigger.throwIfBlank((String)mac, (RuntimeException)new IllegalArgumentException("blank mac"));
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select ld from LanDeviceEntity ld ");
            inquiry.append("left join fetch ld.user ");
            inquiry.append("where ld.mac = :mac ");
            inquiry.append("and ld.deleted = false ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("mac", (Object)mac);
            LanDeviceEntity device = (LanDeviceEntity)query.getSingleResult();
            device.materialize();
            return device;
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException re) {
            log.warn((Object)("Failed to find not deleted deivce for mac=" + mac + ": " + re.getMessage()));
            throw re;
        }
    }

    public List<LanDeviceEntity> findNotDeletedLanDevicesByMac(String mac) {
        log.debug((Object)("start findNotDeletedLanDevicesByMac(mac=" + mac + ")"));
        ExceptionsTrigger.throwIfBlank((String)mac, (RuntimeException)new IllegalArgumentException("blank mac"));
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select ld from LanDeviceEntity ld ");
            inquiry.append("left join fetch ld.user ");
            inquiry.append("where ld.mac = :mac ");
            inquiry.append("and ld.deleted = false ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("mac", (Object)mac);
            List devices = query.getResultList();
            for (LanDeviceEntity device : devices) {
                device.materialize();
            }
            return devices;
        }
        catch (RuntimeException ex) {
            log.warn((Object)("Failed to find not deleted deivce for mac=" + mac + ": " + ex.getMessage()));
            throw ex;
        }
    }

    public LanDeviceEntity findNotDeletedLanDeviceById(Integer lanDeviceId) {
        log.debug((Object)("start findNotDeletedLanDeviceById(lanDeviceId=" + lanDeviceId + ")"));
        if (lanDeviceId == null) {
            return null;
        }
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select ld from LanDeviceEntity ld ");
            inquiry.append("where ld.lanDeviceId = :lanDeviceId ");
            inquiry.append("and ld.deleted = false ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("lanDeviceId", (Object)lanDeviceId);
            LanDeviceEntity lanDevice = (LanDeviceEntity)query.getSingleResult();
            lanDevice.materialize();
            return lanDevice;
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException re) {
            log.warn((Object)("Failed to find not deleted deivce for lanDeviceId=" + lanDeviceId + ": " + re.getMessage()));
            throw re;
        }
    }

    public LanDeviceEntity findLNotDeletedByMacAndUserId(String mac, Integer userId) {
        log.trace((Object)("start findLNotDeletedByMacAndUserId(mac=" + mac + ", userId=" + userId + ")"));
        ExceptionsTrigger.throwIfBlank((String)mac, (RuntimeException)new IllegalArgumentException("blank mac"));
        ExceptionsTrigger.throwIfNull((Object)userId, (RuntimeException)new NullPointerException("null userId"));
        try {
            TypedQuery query = this.em.createNamedQuery("LanDeviceEntity.FIND_NOT_DELETED_BY_MAC_AND_USER_ID", LanDeviceEntity.class);
            query.setParameter("mac", (Object)mac);
            query.setParameter("userId", (Object)userId);
            LanDeviceEntity device = (LanDeviceEntity)query.getSingleResult();
            if (device != null) {
                device.materialize();
            }
            return device;
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"LanDeviceEntity.FIND_NOT_DELETED_BY_MAC_AND_USER_ID", (String)"select l from LanDeviceEntity l where l.mac = :mac and l.user.id = :userId and l.deleted = false", (Exception)ex));
            throw ex;
        }
    }

    public LanDeviceEntity getDeviceByToken(String token) {
        log.trace((Object)("start getDeviceByToken(token=" + token + ")"));
        ExceptionsTrigger.throwIf((boolean)StringUtils.isBlank((CharSequence)token), (RuntimeException)new IllegalArgumentException("blank token"));
        try {
            TypedQuery query = this.em.createNamedQuery("LanDeviceEntity.FIND_BY_TOKEN", LanDeviceEntity.class);
            query.setParameter("token", (Object)token);
            LanDeviceEntity device = (LanDeviceEntity)query.getSingleResult();
            if (device != null) {
                device.materialize();
            }
            return device;
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"LanDeviceEntity.FIND_BY_TOKEN", (String)"select l from LanDeviceEntity l where l.token = :token", (Exception)ex));
            throw ex;
        }
    }

    public List<LanDeviceEntity> findLanDevicesByUserIdWithActiveEvents(Integer userId) {
        List lanDevices;
        block4: {
            log.debug((Object)("start findLanDevicesByUserIdWithActiveEvents(" + userId + ")"));
            lanDevices = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ld from LanDeviceEntity ld, in(ld.events) as event ");
                inquiry.append("where ld.user.id = :userId ");
                inquiry.append("and ld.deleted = false ");
                inquiry.append("and event.deleted = false ");
                inquiry.append("and event.dateStopRequested is not null ");
                inquiry.append("and event.dateStopRequested > :now ");
                inquiry.append("order by ld.name ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                query.setParameter("now", (Object)new Date());
                lanDevices = query.getResultList();
                if (lanDevices != null) {
                    for (LanDeviceEntity device : lanDevices) {
                        device.materialize();
                    }
                }
            }
            catch (RuntimeException re) {
                log.error((Object)"Exception occured finding lan devices.");
                if (!log.isDebugEnabled()) break block4;
                re.printStackTrace();
            }
        }
        return lanDevices;
    }

    public Long countConfiguredCameras(LanDevice.LanDeviceConfigurationStatus configurationStatus) {
        Long result;
        block2: {
            log.debug((Object)("start countConfiguredCameras(configurationStatus=" + configurationStatus + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select count(ld) from LanDeviceEntity ld ");
                inquiry.append("where ld.deleted = false ");
                inquiry.append("and ld.configurationStatus = :status ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("status", (Object)configurationStatus);
                result = (Long)query.getSingleResult();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting configured cameras: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit countConfiguredCameras(configurationStatus=" + configurationStatus + "): " + result));
        return result;
    }

    public List<Object[]> getCameraConfigurationsPerDay(Date dateFrom, Date dateTo) {
        List result;
        block8: {
            log.debug((Object)("start getCameraConfigurationsPerDay(dateFrom=" + dateFrom + ", dateTo=" + dateTo + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select date_date, count(landevice_id) from landevice ");
                inquiry.append("right outer join reportingdate on date_date = date(added_date) ");
                inquiry.append("where ");
                if (dateFrom == null) {
                    inquiry.append("date_date >= date((select min(added_date) from landevice)) ");
                } else {
                    inquiry.append("date_date >= :dateFrom ");
                }
                if (dateTo == null) {
                    inquiry.append(" and date_date <= date(now()) ");
                } else {
                    inquiry.append(" and date_date <= :dateTo ");
                }
                inquiry.append("group by date_date ");
                Query query = this.em.createNativeQuery(inquiry.toString());
                if (dateFrom != null) {
                    query.setParameter("dateFrom", (Object)dateFrom);
                }
                if (dateTo != null) {
                    query.setParameter("dateTo", (Object)dateTo);
                }
                result = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting camera configurations per day: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block8;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit getCameraConfigurationsPerDay(): " + (result == null ? null : Integer.valueOf(result.size()))));
        return result;
    }

    public List<Object[]> getCumulatedCameraConfigurationsPerDay(Date dateFrom, Date dateTo) {
        List result;
        block4: {
            log.debug((Object)("start getCumulatedCameraConfigurationsPerDay(dateFrom=" + dateFrom + ", dateTo=" + dateTo + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select d.date_date, count(*) from reportingdate d, landevice l ");
                inquiry.append("where d.date_date >= date(l.added_date) and d.date_date <= date(now() - interval 1 day) ");
                if (dateFrom != null && dateTo != null) {
                    inquiry.append("and d.date_date >= date(:dateFrom) and d.date_date <= date(:dateTo) ");
                }
                inquiry.append("group by d.date_date ");
                log.debug((Object)("created sql: " + inquiry.toString()));
                Query query = this.em.createNativeQuery(inquiry.toString());
                if (dateFrom != null && dateTo != null) {
                    query.setParameter("dateFrom", (Object)dateFrom);
                    query.setParameter("dateTo", (Object)dateTo);
                }
                result = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting cumulated camera configurations per day: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block4;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit getCumulatedCameraConfigurationsPerDay(): " + (result == null ? null : Integer.valueOf(result.size()))));
        return result;
    }

    public Long countAllLanDeviceByUserId(Integer userId) {
        Long result;
        block2: {
            log.debug((Object)("start countAllLanDeviceByUserId(userId=" + userId + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select count(ld) from LanDeviceEntity ld ");
                inquiry.append("where ld.user.id = :userId ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                result = (Long)query.getSingleResult();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting all lan device for user id=" + userId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit countAllLanDeviceByUserId(userId=" + userId + "): " + result));
        return result;
    }

    public Long countNotDeletedLanDeviceByUserId(Integer userId) {
        return this.countNotDeletedLanDeviceByUserId(userId, null);
    }

    public Long countNotDeletedLanDeviceByUserId(Integer userId, String classDevice) {
        Long result;
        block4: {
            log.debug((Object)("start countNotDeletedLanDeviceByUserId(userId=" + userId + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select count(ld) from LanDeviceEntity ld ");
                inquiry.append("where ld.user.id = :userId ");
                inquiry.append("and ld.deleted = false ");
                if (classDevice != null) {
                    inquiry.append("and ld.deviceDesc.classDevice = :classDevice ");
                }
                log.debug((Object)("created query: " + inquiry.toString()));
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                if (classDevice != null) {
                    query.setParameter("classDevice", (Object)classDevice);
                }
                result = (Long)query.getSingleResult();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting all lan device for user id=" + userId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block4;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit countNotDeletedLanDeviceByUserId(userId=" + userId + "): " + result));
        return result;
    }

    public Long countNotDeletedLanDeviceByUserIdAndGatewayClientId(Integer userId, Integer gatewayClientId) {
        Long result;
        block2: {
            log.debug((Object)("start countNotDeletedLanDeviceByUserIdAndGatewayClientId(userId=" + userId + ", gatewayClientId=" + gatewayClientId + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select count(ld) from LanDeviceEntity ld ");
                inquiry.append("where ld.user.id = :userId ");
                inquiry.append("and ld.deleted = false ");
                inquiry.append("and ld.gatewayClient.gatewayClientId = :gatewayClientId ");
                log.debug((Object)("created query: " + inquiry.toString()));
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                query.setParameter("gatewayClientId", (Object)gatewayClientId);
                result = (Long)query.getSingleResult();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting lan device for user id=" + userId + " and GC " + gatewayClientId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit countNotDeletedLanDeviceByUserIdAndGatewayClientId(userId=" + userId + ", gatewayClientId=" + gatewayClientId + "): " + result));
        return result;
    }

    public Long countNotDeletedLanDevices() {
        Long result;
        block2: {
            log.debug((Object)"start countNotDeletedLanDevices()");
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select count(ld) from LanDeviceEntity ld ");
                inquiry.append("where ld.deleted = false ");
                Query query = this.em.createQuery(inquiry.toString());
                result = (Long)query.getSingleResult();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting not deleted devices: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit countNotDeletedLanDevices(): " + result));
        return result;
    }

    public Double findMaxCameraIndex(Integer userId, String classDevice) {
        Object result;
        block5: {
            log.debug((Object)("start findMaxCameraIndex(userId=" + userId + ")"));
            try {
                String inquiry = this.getFindMaxDeviceIndexInquiry(userId, classDevice);
                log.trace((Object)("created sql: " + inquiry.toString()));
                Query query = this.em.createNativeQuery(inquiry);
                result = query.getSingleResult();
                if (result != null) break block5;
                return null;
            }
            catch (RuntimeException re) {
                log.error((Object)("Failed to find max camera index for userId=" + userId + " and classDevice=" + classDevice + ": " + re.getMessage()));
                if (log.isDebugEnabled()) {
                    re.printStackTrace();
                }
                return null;
            }
        }
        if (this.databaseType == DatabaseType.MYSQL) {
            return (Double)result;
        }
        BigDecimal oracleResult = (BigDecimal)result;
        return oracleResult.doubleValue();
    }

    private String getFindMaxDeviceIndexInquiry(Integer userId, String deviceClass) {
        StringBuilder inquiry = new StringBuilder();
        if (this.databaseType == DatabaseType.MYSQL) {
            if (deviceClass.equalsIgnoreCase("camera")) {
                inquiry.append("select ifnull(max(0+substring(name,9)),0) from landevice where deleted = false and name like 'Camera #%' ");
            } else {
                inquiry.append("select ifnull(max(0+substring(name,6)),0) from landevice where deleted = false and name like 'NAS #%' ");
            }
        } else if (deviceClass.equalsIgnoreCase("camera")) {
            inquiry.append("select nvl(max(0+substr(name,9)),0) from landevice where deleted = 0 and name like 'Camera #%' ");
        } else {
            inquiry.append("select nvl(max(0+substr(name,6)),0) from landevice where deleted = 0 and name like 'Camera #%' ");
        }
        inquiry.append("and user_id = ").append(userId);
        return inquiry.toString();
    }

    public LanDeviceEntity findLanDeviceByAlarmUser(String alamrUser) {
        log.debug((Object)("start findLanDeviceByAlarmUser(alamrUser=" + alamrUser + ")"));
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select ld from LanDeviceEntity ld, in(ld.lanDeviceParams) ldp ");
            inquiry.append("where ldp.name = 'alarm_user' ");
            inquiry.append("and ldp.value = :alarmUser ");
            inquiry.append("and ld.deleted = false ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("alarmUser", (Object)alamrUser);
            LanDeviceEntity lanDevice = (LanDeviceEntity)query.getSingleResult();
            lanDevice.materialize();
            return lanDevice;
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException re) {
            log.warn((Object)("Failed to find lan device for alamrUser=" + alamrUser + ": " + re.getMessage()));
            throw re;
        }
    }

    public LanDeviceEntity findLatestLanDeviceByMac(String macAddress) {
        log.debug((Object)("start findLatestLanDeviceByMac(macAddress=" + macAddress + ")"));
        if (macAddress == null || macAddress.trim().length() == 0) {
            return null;
        }
        try {
            StringBuilder inquiry = new StringBuilder(100);
            inquiry.append("select ld from LanDeviceEntity ld ");
            inquiry.append("left join fetch ld.user ");
            inquiry.append("where ld.mac = :macAddress ");
            inquiry.append("and ld.addedDate = ");
            inquiry.append("(select max(l.addedDate) from LanDeviceEntity l where l.mac = :macAddress)");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("macAddress", (Object)macAddress);
            LanDeviceEntity lanDevice = (LanDeviceEntity)query.getSingleResult();
            lanDevice.materialize();
            return lanDevice;
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException re) {
            log.warn((Object)("Failed to find latest lan device for mac=" + macAddress + ": " + re.getMessage()));
            throw re;
        }
    }

    public LanDeviceEntity findLatestLanDeviceByMacAndUserId(String mac, Integer userId) {
        log.debug((Object)("start findLatestLanDeviceByMacAndUserId(mac=" + mac + ", userId=" + userId + ")"));
        ExceptionsTrigger.throwIfBlank((String)mac, (RuntimeException)new IllegalArgumentException("mac is blank"));
        ExceptionsTrigger.throwIfBlank((String)mac, (RuntimeException)new NullPointerException("userId"));
        try {
            StringBuilder inquiry = new StringBuilder(100);
            inquiry.append("select ld from LanDeviceEntity ld ");
            inquiry.append("where ld.mac = :mac ");
            inquiry.append("and ld.user.id = :userId ");
            inquiry.append("and ld.addedDate = ");
            inquiry.append("(select max(l.addedDate) from LanDeviceEntity l where l.mac = :mac and l.user.id = :userId)");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("mac", (Object)mac);
            query.setParameter("userId", (Object)userId);
            LanDeviceEntity device = (LanDeviceEntity)query.getSingleResult();
            device.materialize();
            return device;
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
    }

    public LanDeviceEntity findLanDeviceByEventId(Integer eventId) {
        log.debug((Object)("start findLanDeviceByEventId(eventId=" + eventId + ")"));
        if (eventId == null) {
            return null;
        }
        LanDeviceEntity lanDevice = null;
        try {
            StringBuilder inquiry = new StringBuilder(100);
            inquiry.append("select ld from LanDeviceEntity ld, in(ld.events) e");
            inquiry.append("where ld.deleted= :false ");
            inquiry.append("and e.event_id = :eventId ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("eventId", (Object)eventId);
            lanDevice = (LanDeviceEntity)query.getSingleResult();
            lanDevice.materialize();
            return lanDevice;
        }
        catch (NoResultException nre) {
            return null;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
    }

    public List<LanDeviceEntity> findLanDevicesByValidTo(Date validTo) {
        List lanDevices;
        block3: {
            log.debug((Object)("start findLanDevicesByValidityTo(validTo=" + validTo + ")"));
            lanDevices = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ld from LanDeviceEntity ld ");
                inquiry.append("where ld.validTo = :validTo ");
                inquiry.append("and ld.deleted = false ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("validTo", validTo, TemporalType.DATE);
                lanDevices = query.getResultList();
                for (LanDeviceEntity device : lanDevices) {
                    device.materialize();
                }
                log.debug((Object)("exit findLanDevicesByValidityTo(validTo=" + validTo + "): " + lanDevices.size()));
            }
            catch (RuntimeException re) {
                log.warn((Object)("Exception occured finding lan devices by validTo=" + validTo + "."));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return lanDevices;
    }

    public LanDeviceEntity findLanDeviceByIdAndLock(Integer lanDeviceId, LockModeType lockModeType) {
        log.debug((Object)("start findLanDeviceByIdAndLock(lanDeviceId=" + lanDeviceId + ", lockModeType=" + lockModeType + ")"));
        LanDeviceEntity lanDevice = null;
        try {
            lanDevice = (LanDeviceEntity)this.em.find(LanDeviceEntity.class, (Object)lanDeviceId, lockModeType);
            lanDevice.materialize();
            return lanDevice;
        }
        catch (NoResultException nre) {
            return null;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
    }

    public List<LanDeviceEntity> findLanDevices(Integer userId, boolean fetchDeleted) {
        List devices;
        block4: {
            log.debug((Object)("start findLanDevices(userId=" + userId + ", fetchDeleted=" + fetchDeleted + ")"));
            devices = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ld from LanDeviceEntity ld ");
                inquiry.append("where ld.user.id = :userId ");
                if (!fetchDeleted) {
                    inquiry.append("and ld.deleted = false ");
                }
                inquiry.append("order by ld.name ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                devices = query.getResultList();
                for (LanDeviceEntity device : devices) {
                    device.materialize();
                }
            }
            catch (RuntimeException re) {
                log.warn((Object)("Error occured findLanDevices(userId=" + userId + ", fetchDeleted=" + fetchDeleted + "): " + re.getMessage() + "."));
                if (!log.isDebugEnabled()) break block4;
                re.printStackTrace();
            }
        }
        log.debug((Object)("end findLanDevices(userId=" + userId + ", fetchDeleted=" + fetchDeleted + "). Result size: " + devices.size() + "."));
        return devices;
    }

    public List<LanDeviceEntity> findLanDevicesByGatewacClientId(Integer gatewayClientId, boolean fetchDeleted) {
        List devices;
        block4: {
            log.debug((Object)("start findLanDevicesByGatewacClientId(gatewayClientId=" + gatewayClientId + ", fetchDeleted=" + fetchDeleted + ")"));
            devices = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ld from LanDeviceEntity ld ");
                inquiry.append("where ld.gatewayClient.gatewayClientId = :gatewayClientId ");
                if (!fetchDeleted) {
                    inquiry.append("and ld.deleted = false ");
                }
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("gatewayClientId", (Object)gatewayClientId);
                devices = query.getResultList();
                for (LanDeviceEntity device : devices) {
                    device.materialize();
                }
            }
            catch (RuntimeException re) {
                log.warn((Object)("Failed to findLanDevicesByGatewacClientId(gatewayClientId=" + gatewayClientId + ", fetchDeleted=" + fetchDeleted + "): " + re.getMessage() + "."));
                if (!log.isDebugEnabled()) break block4;
                re.printStackTrace();
            }
        }
        log.debug((Object)("end findLanDevicesByGatewacClientId(gatewayClientId=" + gatewayClientId + ", fetchDeleted=" + fetchDeleted + "). Result size: " + devices.size() + "."));
        return devices;
    }

    public LanDeviceEntity findLanDeviceByIdSharedWithUser(Integer lanDeviceId, Integer userId) {
        log.debug((Object)("start findLanDeviceByIdSharedWithUser(lanDeviceId=" + lanDeviceId + ", userId=" + userId + ")"));
        LanDeviceEntity lanDevice = null;
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select ld from LanDeviceEntity ld, in(ld.shares) share ");
            inquiry.append("where ld.lanDeviceId = :lanDeviceId ");
            inquiry.append("and ld.deleted = false ");
            inquiry.append("and share.user.id = :userId ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("lanDeviceId", (Object)lanDeviceId);
            query.setParameter("userId", (Object)userId);
            lanDevice = (LanDeviceEntity)query.getSingleResult();
            lanDevice.materialize();
            return lanDevice;
        }
        catch (NoResultException nre) {
            return null;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
    }

    public List<LanDeviceEntity> findLanDevicesSharedWithUserWithActiveEvents(Integer userId, String deviceClass) {
        List lanDevices;
        block5: {
            log.debug((Object)("start findLanDevicesSharedWithUser(userId=" + userId + ", deviceClass=" + deviceClass + ")"));
            lanDevices = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ld from LanDeviceEntity ld, in(ld.shares) share, in(ld.events) as event ");
                inquiry.append("where ld.user.id <> :userId ");
                inquiry.append("and share.user.id = :userId ");
                inquiry.append("and ld.deleted = false ");
                inquiry.append("and event.deleted = false ");
                inquiry.append("and event.dateStopRequested is not null ");
                inquiry.append("and event.dateStopRequested > :now ");
                if (deviceClass != null) {
                    inquiry.append("and ld.deviceDesc.classDevice = :deviceClass ");
                }
                inquiry.append("order by ld.name ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                query.setParameter("now", (Object)new Date());
                if (deviceClass != null) {
                    query.setParameter("deviceClass", (Object)deviceClass);
                }
                lanDevices = query.getResultList();
                for (LanDeviceEntity device : lanDevices) {
                    device.materialize();
                }
            }
            catch (RuntimeException re) {
                log.error((Object)"Exception occured finding lan devices.");
                if (!log.isDebugEnabled()) break block5;
                re.printStackTrace();
            }
        }
        return lanDevices;
    }
}

