/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Repository;
import pl.smartapps.restserver.db.main.GatewayClientVersionEntity;

@Repository
public class GatewayClientVersionDAO {
    private static Logger log = Logger.getLogger(GatewayClientVersionDAO.class);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private JpaTransactionManager txManager;

    public void detach(GatewayClientVersionEntity gatewayClientVersion) {
        this.em.detach((Object)gatewayClientVersion);
    }

    public GatewayClientVersionEntity findBestMatchedGatewayClientVersion(String mac) {
        log.debug((Object)("start findBestMatchedGatewayClientVersion(mac=" + mac + ")"));
        GatewayClientVersionEntity gatewayClientVersion = null;
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select gcv from GatewayClientVersionEntity gcv ");
            inquiry.append("where :mac like concat(gcv.macPrefix,'%') ");
            inquiry.append("order by gcv.macPrefix desc ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("mac", (Object)mac);
            query.setMaxResults(1);
            gatewayClientVersion = (GatewayClientVersionEntity)query.getSingleResult();
        }
        catch (NonUniqueResultException nure) {
            log.warn((Object)("Found more than one gateway client version for mac " + mac));
        }
        catch (NoResultException nre) {
            log.info((Object)("Not found gateway client version for mac " + mac));
        }
        catch (IllegalStateException ise) {
            log.warn((Object)("Exception occurred finding gateway client version for mac " + mac));
        }
        log.debug((Object)("exit findBestMatchedGatewayClientVersion(mac=" + mac + ") gatewayClientVersion = " + (gatewayClientVersion != null ? gatewayClientVersion.toString() : null)));
        return gatewayClientVersion;
    }
}

