/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import pl.smartapps.restserver.db.main.GatewayClientSessionEntity;
import pl.smartapps.restserver.util.ErrorMessages;
import pl.smartapps.restserver.util.ExceptionsTrigger;

@Repository
public class GatewayClientSessionDAO {
    private static Logger log = Logger.getLogger(GatewayClientSessionDAO.class);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private JpaTransactionManager txManager;

    public GatewayClientSessionEntity findGatewayClientSessionByMac(String mac) {
        log.trace((Object)("start findGatewayClientSessionById(mac=" + mac + ")"));
        ExceptionsTrigger.throwIfBlank((String)mac, (RuntimeException)new IllegalArgumentException("blank mac"));
        try {
            TypedQuery query = this.em.createNamedQuery("GatewayClientEntity.FIND_BY_MAC", GatewayClientSessionEntity.class);
            query.setParameter("mac", (Object)mac);
            return (GatewayClientSessionEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"GatewayClientEntity.FIND_BY_MAC", (String)"select g from GatewayClientSessionEntity g where g.mac = :mac", (Exception)ex));
            throw ex;
        }
    }

    public List<GatewayClientSessionEntity> getGatewayClientSessions() {
        log.debug((Object)"start getGatewayClientSessions()");
        try {
            TypedQuery query = this.em.createNamedQuery("GatewayClientEntity.FIND_ALL", GatewayClientSessionEntity.class);
            return query.getResultList();
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"GatewayClientEntity.FIND_ALL", (String)"select g from GatewayClientSessionEntity g", (Exception)ex));
            throw ex;
        }
    }

    public GatewayClientSessionEntity saveGatewayClientSession(GatewayClientSessionEntity gatewayClientSession) {
        block2: {
            log.debug((Object)("start saveGatewayClientSession: " + gatewayClientSession));
            try {
                this.em.persist((Object)gatewayClientSession);
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception saving gateway client session: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return gatewayClientSession;
    }

    public GatewayClientSessionEntity updateGatewayClientSession(GatewayClientSessionEntity gatewayClientSession) {
        block5: {
            block4: {
                log.debug((Object)("start updateGatewayClientSession: " + gatewayClientSession));
                if (gatewayClientSession == null) {
                    return null;
                }
                GatewayClientSessionEntity session = (GatewayClientSessionEntity)this.em.find(GatewayClientSessionEntity.class, (Object)gatewayClientSession.getMac());
                if (session != null) break block4;
                log.debug((Object)("updateGatewayClientSession: not found gatewayClientSession for mac = " + gatewayClientSession.getMac()));
                return null;
            }
            try {
                this.em.merge((Object)gatewayClientSession);
                log.debug((Object)("gatewayClientSession for mac = " + gatewayClientSession.getMac() + " updated"));
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception updating gateway client session: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block5;
                re.printStackTrace();
            }
        }
        return gatewayClientSession;
    }

    public boolean removeGatewayClientSession(String mac) {
        log.debug((Object)("start removeGatewayClientSession(mac: " + mac + ")"));
        boolean result = true;
        try {
            GatewayClientSessionEntity session = (GatewayClientSessionEntity)this.em.find(GatewayClientSessionEntity.class, (Object)mac);
            if (session == null) {
                result = false;
            } else {
                this.em.remove((Object)session);
            }
        }
        catch (RuntimeException re) {
            log.error((Object)("Exception removing gateway client session for mac " + mac + ": " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            result = false;
        }
        return result;
    }

    public boolean clearGatewayClientSesion() {
        log.debug((Object)"start clearGatewayClientSession");
        boolean result = true;
        try {
            Query query = this.em.createQuery("DELETE from GatewayClientSessionEntity");
            query.executeUpdate();
        }
        catch (RuntimeException re) {
            log.error((Object)("Exception clearing gateway client session " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            result = false;
        }
        return result;
    }

    public boolean clearGatewayClientSesionWithTransaction() {
        log.debug((Object)"start clearGatewayClientSesionWithTransaction()");
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("clearGatewayClientSesion transaction");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        boolean result = this.clearGatewayClientSesion();
        this.txManager.commit(status);
        return result;
    }

    public Long countGatewayClientSession() {
        Long result;
        block2: {
            log.debug((Object)"start countGatewayClientSessions()");
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select count(gcs) from GatewayClientSessionEntity gcs ");
                Query query = this.em.createQuery(inquiry.toString());
                result = (Long)query.getSingleResult();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting gateway client sessions: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit countGatewayClientSessions(): " + result));
        return result;
    }
}

