/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import pl.smartapps.hm.WebViewer.shared.model.GcMacId;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.util.ErrorMessages;
import pl.smartapps.restserver.util.ExceptionsTrigger;

@Repository
public class GatewayClientDAO {
    private static Logger log = Logger.getLogger(GatewayClientDAO.class);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private JpaTransactionManager txManager;

    public GatewayClientEntity store(GatewayClientEntity client) {
        if (client == null) {
            log.error((Object)"Store null entity request");
            return null;
        }
        try {
            if (client.getGatewayClientId() != null) {
                return (GatewayClientEntity)this.em.merge((Object)client);
            }
            this.em.persist((Object)client);
            return client;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.STORE_ENTITY_EXCEPTION((Object)client, (Exception)ex));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public List<GatewayClientEntity> findGatewayClientsByUserId(Integer userId) {
        log.debug((Object)("start findGatewayClientsByUserId(userId=" + userId + ")"));
        return this.findGatewayClientsByUserId(userId, false);
    }

    public List<GatewayClientEntity> findGatewayClientsByUserId(Integer userId, boolean fetchLanDevices) {
        List gatewayClients;
        block3: {
            log.debug((Object)("start findGatewayClientsByUserId(userId=" + userId + ", fetchLanDevices=" + fetchLanDevices + ")"));
            gatewayClients = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select distinct gc from GatewayClientEntity gc ");
                if (fetchLanDevices) {
                    inquiry.append("join fetch gc.lanDevices ");
                }
                inquiry.append("where gc.user.id = :userId ");
                inquiry.append("and gc.deleted = false ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                gatewayClients = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding gateway clients for user with id = " + userId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return gatewayClients;
    }

    public GatewayClientEntity findGatewayClientById(Integer gatewayClientId, boolean fetchLanDevices) {
        GatewayClientEntity gatewayClient;
        block5: {
            log.debug((Object)("start findGatewayClientById(gatewayClientId=" + gatewayClientId + ")"));
            gatewayClient = null;
            try {
                StringBuilder inquiry = new StringBuilder("select gc from GatewayClientEntity gc ");
                if (fetchLanDevices) {
                    inquiry.append("join fetch gc.lanDevices ");
                }
                inquiry.append("where gc.gatewayClientId = :gatewayClientId");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("gatewayClientId", (Object)gatewayClientId);
                gatewayClient = (GatewayClientEntity)query.getSingleResult();
            }
            catch (NonUniqueResultException nure) {
                log.error((Object)("Found more than one gateway client for id " + gatewayClientId));
            }
            catch (NoResultException nre) {
                log.info((Object)("No found gateway client for id " + gatewayClientId));
            }
            catch (IllegalStateException ise) {
                log.error((Object)("Exception occured finding gateway client for id " + gatewayClientId));
                if (!log.isDebugEnabled()) break block5;
                ise.printStackTrace();
            }
        }
        return gatewayClient;
    }

    public GatewayClientEntity findGatewayClientByIdAndUserId(Integer gatewayClientId, Integer userId, boolean fetchLanDevices) {
        GatewayClientEntity gatewayClient;
        block5: {
            log.debug((Object)("start findGatewayClientByIdAndUserId(gatewayClientId=" + gatewayClientId + ", userId=" + userId + ")"));
            gatewayClient = null;
            try {
                StringBuilder inquiry = new StringBuilder("select gc from GatewayClientEntity gc ");
                if (fetchLanDevices) {
                    inquiry.append("join fetch gc.lanDevices ");
                }
                inquiry.append("where gc.gatewayClientId = :gatewayClientId and gc.deleted = false ");
                inquiry.append("and gc.user.id = :userId");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("gatewayClientId", (Object)gatewayClientId);
                query.setParameter("userId", (Object)userId);
                gatewayClient = (GatewayClientEntity)query.getSingleResult();
            }
            catch (NonUniqueResultException nure) {
                log.error((Object)("Found more than one gateway client for id " + gatewayClientId + " and userId " + userId + "."));
            }
            catch (NoResultException nre) {
                log.info((Object)("No found gateway client for id " + gatewayClientId + " and userId " + userId + "."));
            }
            catch (IllegalStateException ise) {
                log.error((Object)("Exception occured finding gateway client for id " + gatewayClientId + " and userId " + userId + "."));
                if (!log.isDebugEnabled()) break block5;
                ise.printStackTrace();
            }
        }
        return gatewayClient;
    }

    public GatewayClientEntity findGatewayClientByIdSharedWithUserId(Integer gatewayClientId, Integer userId) {
        GatewayClientEntity gatewayClient;
        block4: {
            log.debug((Object)("start findGatewayClientByIdSharedWithUserId(gatewayClientId=" + gatewayClientId + ", userId=" + userId + ")"));
            gatewayClient = null;
            try {
                StringBuilder inquiry = new StringBuilder("select gc from GatewayClientEntity gc, in(gc.lanDevices) lanDevice, in(lanDevice.shares) share ");
                inquiry.append("where gc.gatewayClientId = :gatewayClientId ");
                inquiry.append("and gc.deleted = false ");
                inquiry.append("and (share.user.id = :userId)");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("gatewayClientId", (Object)gatewayClientId);
                query.setParameter("userId", (Object)userId);
                gatewayClient = (GatewayClientEntity)query.getSingleResult();
            }
            catch (NonUniqueResultException nure) {
                log.error((Object)("Found more than one gateway client for id " + gatewayClientId + " and userId " + userId + "."));
            }
            catch (NoResultException nre) {
                log.info((Object)("No found gateway client for id " + gatewayClientId + " and userId " + userId + "."));
            }
            catch (IllegalStateException ise) {
                log.error((Object)("Exception occured finding gateway client for id " + gatewayClientId + " and userId " + userId + "."));
                if (!log.isDebugEnabled()) break block4;
                ise.printStackTrace();
            }
        }
        return gatewayClient;
    }

    public GatewayClientEntity findNotDeletedGatewayClientByIdAndUserId(Integer gatewayClientId) {
        GatewayClientEntity gatewayClient;
        block4: {
            log.debug((Object)("start findNotDeletedGatewayClientByIdAndUserId(gatewayClientId=" + gatewayClientId + ")"));
            gatewayClient = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select gc from GatewayClientEntity gc ");
                inquiry.append("where gc.gatewayClientId = :gatewayClientId ");
                inquiry.append("and gc.deleted = false ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("gatewayClientId", (Object)gatewayClientId);
                gatewayClient = (GatewayClientEntity)query.getSingleResult();
            }
            catch (NonUniqueResultException nure) {
                log.error((Object)("Found more than one gateway client for id " + gatewayClientId + "."));
            }
            catch (NoResultException nre) {
                log.info((Object)("No found gateway client for id " + gatewayClientId + "."));
            }
            catch (IllegalStateException ise) {
                log.error((Object)("Exception occured finding gateway client for id " + gatewayClientId + ": " + ise.getMessage()));
                if (!log.isDebugEnabled()) break block4;
                ise.printStackTrace();
            }
        }
        return gatewayClient;
    }

    public List<GatewayClientEntity> findGatewayClientsByMacAddress(String mac) {
        ExceptionsTrigger.throwIfBlank((String)mac, (RuntimeException)new IllegalArgumentException("blank mac"));
        try {
            TypedQuery query = this.em.createNamedQuery("GatewayClientEntity.FIND_NOT_DELETED_BY_MAC", GatewayClientEntity.class);
            query.setParameter("mac", (Object)mac);
            return query.getResultList();
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"GatewayClientEntity.FIND_NOT_DELETED_BY_MAC", (String)"select g from GatewayClientEntity g where g.mac = :mac and g.deleted = false", (Exception)ex));
            throw ex;
        }
    }

    public GatewayClientEntity findGatewayClientByMacAndUserId(String mac, Integer userId) {
        log.trace((Object)("start findGatewayClientByMacAndUserId(mac=" + mac + ", userId=" + userId + ")"));
        ExceptionsTrigger.throwIfBlank((String)mac, (RuntimeException)new IllegalArgumentException("blank mac"));
        ExceptionsTrigger.throwIfNull((Object)userId, (RuntimeException)new NullPointerException("null userId"));
        try {
            TypedQuery query = this.em.createNamedQuery("GatewayClientEntity.FIND_NOT_DELETED_BY_MAC_AND_USER_ID", GatewayClientEntity.class);
            query.setParameter("mac", (Object)mac);
            query.setParameter("userId", (Object)userId);
            return (GatewayClientEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"GatewayClientEntity.FIND_NOT_DELETED_BY_MAC_AND_USER_ID", (String)"select g from GatewayClientEntity g where g.mac = :mac and g.user.id = :userId and g.deleted = false", (Exception)ex));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }

    public GatewayClientEntity findGatewayClientByIdAndUserId(Integer id, Integer userId) {
        log.trace((Object)("start findGatewayClientByIdAndUserId(id=" + id + ", userId=" + userId + ")"));
        ExceptionsTrigger.throwIfNull((Object)id, (RuntimeException)new NullPointerException("null id"));
        ExceptionsTrigger.throwIfNull((Object)userId, (RuntimeException)new NullPointerException("null userId"));
        try {
            TypedQuery query = this.em.createNamedQuery("GatewayClientEntity.FIND_NOT_DELETED_BY_ID_AND_USER_ID", GatewayClientEntity.class);
            query.setParameter("gatewayClientId", (Object)id);
            query.setParameter("userId", (Object)userId);
            return (GatewayClientEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"GatewayClientEntity.FIND_NOT_DELETED_BY_ID_AND_USER_ID", (String)"select g from GatewayClientEntity g where g.gatewayClientId = :gatewayClientId and g.user.id = :userId and g.deleted = false", (Exception)ex));
            throw ex;
        }
    }

    public GatewayClientEntity saveGatewayClient(GatewayClientEntity gatewayClient) {
        block2: {
            log.debug((Object)"start saveGatewayClient");
            try {
                this.em.persist((Object)gatewayClient);
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception saveing gateway client: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return gatewayClient;
    }

    public boolean removeGatewayClient(int id) {
        log.debug((Object)("start removeGatewayClient(" + id + ")"));
        boolean result = true;
        try {
            GatewayClientEntity client = (GatewayClientEntity)this.em.find(GatewayClientEntity.class, (Object)id);
            if (client == null) {
                result = false;
            } else {
                this.em.remove((Object)client);
            }
        }
        catch (RuntimeException re) {
            log.error((Object)("Exception removing gateway client for id " + id + ": " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            result = false;
        }
        return result;
    }

    public GatewayClientEntity updateGatewayClient(GatewayClientEntity gatewayClient) {
        GatewayClientEntity mergedLanDevice;
        block2: {
            log.debug((Object)("start updateGatewayClient(gatewayClient=" + gatewayClient + ")"));
            mergedLanDevice = null;
            try {
                mergedLanDevice = (GatewayClientEntity)this.em.merge((Object)gatewayClient);
            }
            catch (RuntimeException re) {
                log.error((Object)("Error updating gateway client: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return mergedLanDevice;
    }

    public GatewayClientEntity updateGatewayClientWithTransaction(GatewayClientEntity gatewayClient) {
        log.debug((Object)("start updateGatewayClientWithTransaction(gatewayClient=" + gatewayClient + "."));
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("updateGatewayClient transaction");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        GatewayClientEntity result = this.updateGatewayClient(gatewayClient);
        this.txManager.commit(status);
        return result;
    }

    public Long countGatewayClientsForUserId(Integer userId) {
        log.debug((Object)("start countGagewayClientsForUserId(userId=" + userId + ")"));
        try {
            String inquiry = "select count(gc) from GatewayClientEntity gc where gc.user.id = :userId and gc.deleted = false";
            Query query = this.em.createQuery(inquiry);
            query.setParameter("userId", (Object)userId);
            return (Long)query.getSingleResult();
        }
        catch (RuntimeException re) {
            log.error((Object)("Error counting gateway clients for user with id = " + userId));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return null;
        }
    }

    public Long countActivatedGatewayClients() {
        Long result;
        block2: {
            log.debug((Object)"start countActivatedGatewayClients()");
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select count(gc) from GatewayClientEntity gc ");
                inquiry.append("where gc.deleted = false ");
                Query query = this.em.createQuery(inquiry.toString());
                result = (Long)query.getSingleResult();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting activated gateway clinets: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit countActivatedGatewayClients(): " + result));
        return result;
    }

    public List<Object[]> getActivatedGatewayClientsPerDay(Date dateFrom, Date dateTo) {
        List result;
        block8: {
            log.debug((Object)("start getActivatedGatewayClientsPerDay(dateFrom=" + dateFrom + ", dateTo=" + dateTo + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select date_date, count(gateway_client_id) from gatewayclient ");
                inquiry.append("right outer join reportingdate on date_date = date(activation_date) ");
                inquiry.append("where ");
                if (dateFrom == null) {
                    inquiry.append("date_date >= date((select min(activation_date) from gatewayclient)) ");
                } else {
                    inquiry.append("date_date >= :dateFrom ");
                }
                if (dateTo == null) {
                    inquiry.append(" and date_date <= date(now()) ");
                } else {
                    inquiry.append(" and date_date <= :dateTo ");
                }
                inquiry.append("group by date_date ");
                Query query = this.em.createNativeQuery(inquiry.toString());
                if (dateFrom != null) {
                    query.setParameter("dateFrom", (Object)dateFrom);
                }
                if (dateTo != null) {
                    query.setParameter("dateTo", (Object)dateTo);
                }
                result = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting activated gateway clients per day: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block8;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit getActivatedGatewayClientsPerDay(): " + (result == null ? null : Integer.valueOf(result.size()))));
        return result;
    }

    public List<Object[]> getCumulatedActivatedGatewayClientsPerDay(Date dateFrom, Date dateTo) {
        List result;
        block4: {
            log.debug((Object)("start getCumulatedActivatedGatewayClientsPerDay(dateFrom=" + dateFrom + ", dateTo=" + dateTo + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select d.date_date, count(*) from reportingdate d, gatewayclient g ");
                inquiry.append("where d.date_date >= date(g.activation_date) and d.date_date <= date(now() - interval 1 day) ");
                if (dateFrom != null && dateTo != null) {
                    inquiry.append("and d.date_date >= date(:dateFrom) and d.date_date <= date(:dateTo) ");
                }
                inquiry.append("group by d.date_date; ");
                Query query = this.em.createNativeQuery(inquiry.toString());
                if (dateFrom != null && dateTo != null) {
                    query.setParameter("dateFrom", (Object)dateFrom);
                    query.setParameter("dateTo", (Object)dateTo);
                }
                result = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting activated gateway clients per day: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block4;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit getActivatedGatewayClientsPerDay(): " + (result == null ? null : Integer.valueOf(result.size()))));
        return result;
    }

    public List<GatewayClientEntity> findGatewayClientsWithCorrectDevicesByUserId(Integer userId) {
        List result;
        block2: {
            log.debug((Object)("start findGatewayClientsWithCorrectDevicesByUserId(userId=" + userId + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select gc from GatewayClientEntity gc, in(gc.lanDevices) as ld ");
                inquiry.append("where gc.deleted = false ");
                inquiry.append("and gc.user.id = :userId ");
                inquiry.append("and ld.deleted = false ");
                inquiry.append("and ld.configurationStatus = 'OK' ");
                log.debug((Object)("created query: " + inquiry.toString()));
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                result = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Failed to find gateway clients with correct devices for userId=" + userId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit findGatewayClientsWithCorrectDevicesByUserId(): " + (result == null ? null : Integer.valueOf(result.size()))));
        return result;
    }

    public List<GatewayClientEntity> findGatewayClients(Integer userId, boolean fetchDeleted) {
        List clients;
        block3: {
            log.debug((Object)("start findGatewayClients(userId=" + userId + ", fetchDeleted=" + fetchDeleted + ")"));
            clients = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select gc from GatewayClientEntity gc ");
                inquiry.append("where gc.user.id = :userId ");
                if (!fetchDeleted) {
                    inquiry.append("and gc.deleted = false ");
                }
                inquiry.append("order by gc.activationDate ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                clients = query.getResultList();
            }
            catch (RuntimeException re) {
                log.warn((Object)("Error occured finding gaeway clients for userId=" + userId + ": " + re.getMessage() + "."));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        log.debug((Object)("end findGatewayClients(userId=" + userId + ", fetchDeleted=" + fetchDeleted + "). Result size: " + clients.size() + "."));
        return clients;
    }

    public Map<String, Integer> countGatewayClientsForEachVersion() {
        log.debug((Object)"start countGatewayClientsForEachVersion()");
        try {
            String inquiry = "select gc.version, gc.buildNo, count(gc) from GatewayClientEntity gc where gc.deleted=0 group by gc.version, gc.buildNo";
            Query query = this.em.createQuery(inquiry);
            HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
            List results = query.getResultList();
            for (Object[] res : results) {
                resultMap.put(String.valueOf((String)res[0]) + "(" + (Integer)res[1] + ")", new Integer(((Long)res[2]).intValue()));
            }
            return resultMap;
        }
        catch (RuntimeException re) {
            log.error((Object)"Error counting gateway clients for each version");
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return null;
        }
    }

    public List<GcMacId> getGatewayClientsForVersion(String version) {
        log.debug((Object)("start getGatewayClientsForVersion(version=" + version + ")"));
        String ver = version.substring(0, version.indexOf("("));
        String buildNo = version.substring(version.indexOf("(") + 1, version.indexOf(")"));
        try {
            String inquiry = "select gc.gatewayClientId, gc.mac from GatewayClientEntity gc where gc.deleted=0 and ";
            inquiry = ver.equals("null") ? String.valueOf(inquiry) + "gc.version is null " : String.valueOf(inquiry) + "gc.version=:ver ";
            inquiry = buildNo.equals("null") ? String.valueOf(inquiry) + "and gc.buildNo is null" : String.valueOf(inquiry) + "and gc.buildNo=:buildNo";
            log.debug((Object)inquiry);
            Query query = this.em.createQuery(inquiry);
            if (!ver.equals("null")) {
                query.setParameter("ver", (Object)ver);
            }
            if (!buildNo.equals("null")) {
                query.setParameter("buildNo", (Object)Integer.parseInt(buildNo));
            }
            ArrayList<GcMacId> resultList = new ArrayList<GcMacId>();
            List results = query.getResultList();
            for (Object[] res : results) {
                GcMacId gc = new GcMacId();
                gc.setId((Integer)res[0]);
                gc.setMac((String)res[1]);
                resultList.add(gc);
            }
            log.debug((Object)("end getGatewayClientsForVersion(result = " + ((Object)resultList).toString() + ")"));
            return resultList;
        }
        catch (RuntimeException re) {
            log.error((Object)"Error counting gateway clients for given version");
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return null;
        }
    }

    public List<GatewayClientEntity> getGatewayClients(String version, Integer buildNo, Integer count) {
        log.debug((Object)("start getGatewayClientsByVersion(version=" + version + ", buildNo=" + buildNo + ", count=" + count + ")"));
        List clients = null;
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select gc from GatewayClientEntity gc ");
            inquiry.append("where gc.deleted = false ");
            if (version == null) {
                inquiry.append("and gc.version is null ");
            } else {
                inquiry.append("and gc.version = :version ");
            }
            if (buildNo == null) {
                inquiry.append("and gc.buildNo is null ");
            } else {
                inquiry.append("and gc.buildNo = :buildNo ");
            }
            Query query = this.em.createQuery(inquiry.toString());
            if (version != null) {
                query.setParameter("version", (Object)version);
            }
            if (buildNo != null) {
                query.setParameter("buildNo", (Object)buildNo);
            }
            if (count != null && count > 0) {
                query.setMaxResults(count.intValue());
            }
            clients = query.getResultList();
            log.debug((Object)("end getGatewayClientsByVersion(version=" + version + ", buildNo=" + buildNo + ", count=" + count + "): result size: " + (clients == null ? "null" : Integer.valueOf(clients.size())) + "."));
            return clients;
        }
        catch (RuntimeException re) {
            log.error((Object)("Error getting gateway clients for version=" + version + " and buildNo=" + buildNo + ": " + re.getMessage() + "."));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return null;
        }
    }

    public GatewayClientEntity saveGatewayClientWithTransaction(GatewayClientEntity gatewayClient) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("saveGatewayClient transaction");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        GatewayClientEntity result = this.saveGatewayClient(gatewayClient);
        this.txManager.commit(status);
        return result;
    }
}

