/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import pl.smartapps.hm.WebViewer.shared.model.EventlogSource;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.EventlogEntity;
import pl.smartapps.restserver.util.Utils;

@Repository
public class EventlogDAO {
    private static Logger log = Logger.getLogger(UserDAO.class);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private JpaTransactionManager txManager;

    public EventlogEntity createEventlog(EventlogEntity eventlog) {
        block2: {
            log.trace((Object)("start createEventlog(eventlog=" + eventlog.dump() + ")"));
            try {
                this.em.persist((Object)eventlog);
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception creating eventlog: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return eventlog;
    }

    public EventlogEntity createEventlogWithTransaction(EventlogEntity eventlog) {
        log.debug((Object)("start createEventlogWithTransaction(eventlog=" + eventlog + ")"));
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("create eventlog transaction");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        EventlogEntity result = this.createEventlog(eventlog);
        this.txManager.commit(status);
        return result;
    }

    public List<EventlogEntity> findEventlogs() {
        List eventlogs;
        block2: {
            log.debug((Object)"start findEventlogs()");
            eventlogs = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select el from EventlogEntity el ");
                inquiry.append("order by el.timestamp ");
                Query query = this.em.createQuery(inquiry.toString());
                eventlogs = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding eventlogs: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("findEventlogs result size: " + eventlogs.size()));
        return eventlogs;
    }

    public List<EventlogEntity> findEventlogs(Date dateFrom, Date dateTo, EventlogSource source, String macAddress, String ipAddress, String eventType) {
        List eventlogs;
        block17: {
            log.debug((Object)("start findEventlogs(startDate=" + dateFrom + ", endDate=" + dateTo + ", source=" + source + ", macAddress=" + macAddress + ", ipAddress=" + ipAddress + ", eventType=" + eventType + ")"));
            eventlogs = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select el from EventlogEntity el ");
                ArrayList<String> whereElements = new ArrayList<String>();
                if (dateFrom != null) {
                    whereElements.add("el.timestamp >= :dateFrom ");
                }
                if (dateTo != null) {
                    whereElements.add("el.timestamp <= :dateTo ");
                }
                if (source != null) {
                    whereElements.add("el.source = :source ");
                }
                if (macAddress != null) {
                    whereElements.add("el.sourceMac like lower(:sourceMacAddress) ");
                }
                if (ipAddress != null) {
                    whereElements.add("el.sourceIp like lower(:sourceIpAddress) ");
                }
                if (eventType != null) {
                    whereElements.add("el.eventType = :eventType ");
                }
                if (!whereElements.isEmpty()) {
                    inquiry.append("where ");
                    boolean firstWhere = true;
                    for (String whereElement : whereElements) {
                        if (firstWhere) {
                            inquiry.append(whereElement);
                            firstWhere = false;
                            continue;
                        }
                        inquiry.append("and ").append(whereElement);
                    }
                }
                inquiry.append("order by el.timestamp desc ");
                Query query = this.em.createQuery(inquiry.toString());
                if (dateFrom != null) {
                    query.setParameter("dateFrom", Utils.adjustTime((Date)dateFrom, (int)0, (int)0, (int)0, (int)0), TemporalType.TIMESTAMP);
                }
                if (dateTo != null) {
                    query.setParameter("dateTo", Utils.adjustTime((Date)dateTo, (int)23, (int)59, (int)59, (int)999), TemporalType.TIMESTAMP);
                }
                if (source != null) {
                    query.setParameter("source", (Object)source.name());
                }
                if (macAddress != null) {
                    query.setParameter("sourceMacAddress", (Object)("%" + macAddress + "%"));
                }
                if (ipAddress != null) {
                    query.setParameter("sourceIpAddress", (Object)("%" + ipAddress + "%"));
                }
                if (eventType != null) {
                    query.setParameter("eventType", (Object)eventType);
                }
                eventlogs = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding eventlogs: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block17;
                re.printStackTrace();
            }
        }
        log.debug((Object)("findEventlogs result size: " + eventlogs.size()));
        return eventlogs;
    }

    public List<Object[]> getDailyIceSessionSetUpCount(Date dateFrom, Date dateTo) {
        List result;
        block8: {
            log.debug((Object)("start getDailyIceSessionSetUpCount(dateFrom=" + dateFrom + ", dateTo=" + dateTo + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select date_date, count(event_id) from eventlog ");
                inquiry.append("right outer join reportingdate on date_date = date(timestamp) ");
                inquiry.append("and event_type = 'ICESETUP' ");
                inquiry.append("and source = 'GC' ");
                inquiry.append("and status = 'OK' ");
                inquiry.append("where ");
                if (dateFrom == null) {
                    inquiry.append("date_date >= date((select min(timestamp) from eventlog where event_type = 'ICESETUP' and source = 'GC' and status = 'OK')) ");
                } else {
                    inquiry.append("date_date >= :dateFrom ");
                }
                if (dateTo == null) {
                    inquiry.append(" and date_date <= date(now()) ");
                } else {
                    inquiry.append(" and date_date <= :dateTo ");
                }
                inquiry.append("group by date_date ");
                log.debug((Object)("created query: " + inquiry.toString()));
                Query query = this.em.createNativeQuery(inquiry.toString());
                if (dateFrom != null) {
                    query.setParameter("dateFrom", (Object)dateFrom);
                }
                if (dateTo != null) {
                    query.setParameter("dateTo", (Object)dateTo);
                }
                result = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting daily ICE session set up: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block8;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit getDailyIceSessionSetUpCount(): " + (result == null ? null : Integer.valueOf(result.size()))));
        return result;
    }

    public List<Object[]> getHourlyIceSessionSetUpCount(Date date) {
        List result;
        block2: {
            log.debug((Object)("start getHourlyIceSessionSetUpCount(date=" + date + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select hour, count(event_id) from eventlog ");
                inquiry.append("right outer join reportinghour on hour = hour(timestamp) ");
                inquiry.append("and event_type = 'ICESETUP' ");
                inquiry.append("and source = 'GC' ");
                inquiry.append("and status = 'OK' ");
                inquiry.append("and date(timestamp) = date(:date) ");
                inquiry.append("group by hour; ");
                Query query = this.em.createNativeQuery(inquiry.toString());
                query.setParameter("date", (Object)date);
                result = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting hourly ICE session set up: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit getHourlyIceSessionSetUpCount(): " + (result == null ? null : Integer.valueOf(result.size()))));
        return result;
    }

    public List<Object[]> getDailyGatewayClientConnectionsCount(Date dateFrom, Date dateTo) {
        List result;
        block8: {
            log.debug((Object)("start getDailyGatewayClientConnectionsCount(dateFrom=" + dateFrom + ", dateTo=" + dateTo + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select date_date, count(event_id) from eventlog ");
                inquiry.append("right outer join reportingdate on date_date = date(timestamp) ");
                inquiry.append("and event_type = 'CONNECT' ");
                inquiry.append("and source = 'GC' ");
                inquiry.append("where ");
                if (dateFrom == null) {
                    inquiry.append("date_date >= date((select min(timestamp) from eventlog where event_type = 'CONNECT' and source = 'GC')) ");
                } else {
                    inquiry.append("date_date >= :dateFrom ");
                }
                if (dateTo == null) {
                    inquiry.append(" and date_date <= date(now()) ");
                } else {
                    inquiry.append(" and date_date <= :dateTo ");
                }
                inquiry.append("group by date_date ");
                log.debug((Object)("created query: " + inquiry.toString()));
                Query query = this.em.createNativeQuery(inquiry.toString());
                if (dateFrom != null) {
                    query.setParameter("dateFrom", (Object)dateFrom);
                }
                if (dateTo != null) {
                    query.setParameter("dateTo", (Object)dateTo);
                }
                result = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting daily gateway client connections: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block8;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit getDailyGatewayClientConnectionsCount(): " + (result == null ? null : Integer.valueOf(result.size()))));
        return result;
    }

    public List<Object[]> getHourlyGatewayClientConnectionsCount(Date date) {
        List result;
        block2: {
            log.debug((Object)("start getHourlyGatewayClientConnectionsCount(date=" + date + ")"));
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select hour, count(event_id) from eventlog ");
                inquiry.append("right outer join reportinghour on hour = hour(timestamp) ");
                inquiry.append("and event_type = 'CONNECT' ");
                inquiry.append("and source = 'GC' ");
                inquiry.append("and date(timestamp) = date(:date) ");
                inquiry.append("group by hour; ");
                Query query = this.em.createNativeQuery(inquiry.toString());
                query.setParameter("date", (Object)date);
                result = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting hourly gateway client connections: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit getHourlyGatewayClientConnectionsCount(): " + (result == null ? null : Integer.valueOf(result.size()))));
        return result;
    }
}

