/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import pl.smartapps.restserver.db.main.EventNotificationEntity;
import pl.smartapps.restserver.service.impl.EventNotificationType;

@Repository
public class EventNotificationDAO {
    private static Logger log = Logger.getLogger(EventNotificationEntity.class);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private JpaTransactionManager txManager;

    public EventNotificationEntity createEventNotification(EventNotificationEntity eventNotification) {
        log.debug((Object)("start createEventNotification(eventNotification=" + eventNotification + ")"));
        try {
            this.em.persist((Object)eventNotification);
        }
        catch (Exception re) {
            log.error((Object)("Exception creating event notification: " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            eventNotification = null;
        }
        return eventNotification;
    }

    public EventNotificationEntity createEventNotificationWithTransaction(EventNotificationEntity eventNotification) {
        log.debug((Object)("start createEventNotificationWithTransaction(eventNotification=" + eventNotification + "."));
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("createEventNotification transaction");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        EventNotificationEntity result = this.createEventNotification(eventNotification);
        this.txManager.commit(status);
        return result;
    }

    public EventNotificationEntity updateEventNotification(EventNotificationEntity eventNotification) {
        EventNotificationEntity mergedEventNotification;
        block2: {
            log.debug((Object)("start updateEventNotification(eventNotification=" + eventNotification + ")"));
            mergedEventNotification = null;
            try {
                mergedEventNotification = (EventNotificationEntity)this.em.merge((Object)eventNotification);
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception updating event notification: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return mergedEventNotification;
    }

    public List<EventNotificationEntity> findEventNotificationsByLanDeviceId(Integer lanDeviceId) {
        List eventNotifications;
        block2: {
            log.debug((Object)("start findEventNotificationsByLanDeviceId(lanDeviceId=" + lanDeviceId + ")"));
            eventNotifications = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select en from EventNotificationEntity en ");
                inquiry.append("where en.lanDevice.lanDeviceId = :lanDeviceId ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("lanDeviceId", (Object)lanDeviceId);
                eventNotifications = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding event notifications by lanDeviceId=" + lanDeviceId + "."));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return eventNotifications;
    }

    public List<EventNotificationEntity> findEventNotificationsByLanDeviceIdAndType(Integer lanDeviceId, EventNotificationType notificationType) {
        List eventNotifications;
        block2: {
            log.debug((Object)("start findEventNotificationsByLanDeviceId(lanDeviceId=" + lanDeviceId + ")"));
            eventNotifications = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select en from EventNotificationEntity en ");
                inquiry.append("where en.lanDevice.lanDeviceId = :lanDeviceId ");
                inquiry.append("and en.notificationType = :notificationType ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("lanDeviceId", (Object)lanDeviceId);
                query.setParameter("notificationType", (Object)notificationType.name());
                eventNotifications = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding event notifications by lanDeviceId=" + lanDeviceId + " and notificationType=" + notificationType.name() + "."));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return eventNotifications;
    }

    public List<EventNotificationEntity> findEventNotificationsByToken(String token) {
        List eventNotifications;
        block2: {
            log.debug((Object)("start findEventNotificationsByToken(token=" + token + ")"));
            eventNotifications = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select en from EventNotificationEntity en ");
                inquiry.append("where en.token = :token ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("token", (Object)token);
                eventNotifications = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding evet notifications by token=" + token + "."));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return eventNotifications;
    }

    public EventNotificationEntity findEventNotificationsByLanDeviceIdAndToken(Integer lanDeviceId, String token) {
        EventNotificationEntity eventNotification;
        block3: {
            log.debug((Object)("start findEventNotificationsByLanDeviceIdAndToken(lanDeviceId=" + lanDeviceId + ", token=" + token + ")"));
            eventNotification = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select en from EventNotificationEntity en ");
                inquiry.append("where en.lanDevice.lanDeviceId = :lanDeviceId ");
                inquiry.append("and en.token = :token ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("lanDeviceId", (Object)lanDeviceId);
                query.setParameter("token", (Object)token);
                eventNotification = (EventNotificationEntity)query.getSingleResult();
            }
            catch (NoResultException nre) {
                log.info((Object)("No event notification found for lanDeviceId=" + lanDeviceId + " and token=" + token + "."));
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding evet notification by lanDeviceId=" + lanDeviceId + " and token=" + token + "."));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return eventNotification;
    }

    public boolean removeEventNotification(EventNotificationEntity eventNotification) {
        log.debug((Object)("start removeEventNotification(eventNotification=" + eventNotification + ")"));
        try {
            this.em.remove(this.em.merge((Object)eventNotification));
        }
        catch (RuntimeException re) {
            log.error((Object)("Exception removing event notification: " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public boolean removeEventNotificationWithTransaction(EventNotificationEntity eventNotification) {
        log.debug((Object)("start removeEventNotificationWithTransaction(eventNotification=" + eventNotification + "."));
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("removeEventNotification transaction");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        boolean result = this.removeEventNotification(eventNotification);
        this.txManager.commit(status);
        return result;
    }

    public int removeEventNotifications(Set<String> tokens) {
        log.debug((Object)("start removeEventNotifications(tokens=" + tokens + ")"));
        try {
            Query query = this.em.createQuery("delete from EventNotificationEntity en where en.token in (:tokens)");
            query.setParameter("tokens", tokens);
            return query.executeUpdate();
        }
        catch (RuntimeException re) {
            log.error((Object)("Exception removing event notification: " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return 0;
        }
    }

    public boolean removeEventNotificationByEventNotificationTypeAndToken(EventNotificationType eventNotificationType, String token) {
        log.debug((Object)("start removeEventNotifications(eventNotificationType=" + eventNotificationType + ", token=" + token + ")"));
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("delete from EventNotificationEntity en where en.token = (:token)");
            inquiry.append("and en.eventNotificationType = :eventNotificationType ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("token", (Object)token);
            query.setParameter("eventNotificationType", (Object)eventNotificationType.name());
            return query.executeUpdate() == 1;
        }
        catch (RuntimeException re) {
            log.error((Object)("Exception removing event notification: " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return false;
        }
    }
}

