/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.main.EventEntity;

@Repository
public class EventDAOImpl
implements EventDAO {
    private static Logger log = Logger.getLogger(EventDAOImpl.class);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private JpaTransactionManager txManager;

    @Transactional
    public EventEntity createEvent(EventEntity event) {
        block2: {
            log.debug((Object)("start createEvent(" + event + ")"));
            try {
                this.em.persist((Object)event);
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception creating event: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return event;
    }

    public EventEntity findEventById(Integer eventId) {
        EventEntity event;
        block3: {
            log.debug((Object)("start findEventById(id=" + eventId + ")"));
            event = null;
            try {
                StringBuilder inquiry = new StringBuilder("select ee from EventEntity ee ");
                inquiry.append("where ee.eventId = :eventId ");
                inquiry.append("and ee.deleted = false");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("eventId", (Object)eventId);
                event = (EventEntity)query.getSingleResult();
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found event for id " + eventId));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding event by id=" + eventId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return event;
    }

    public EventEntity findEventByIdAndUserId(Integer eventId, Integer userId) {
        EventEntity event;
        block3: {
            log.debug((Object)("start findEventByIdAndUserId(eventId=" + eventId + ", userId=" + userId + ")"));
            event = null;
            try {
                StringBuilder inquiry = new StringBuilder("select ee from EventEntity ee ");
                inquiry.append("where ee.eventId = :eventId ");
                inquiry.append("and ee.lanDevice.user.id = :userId");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("eventId", (Object)eventId);
                query.setParameter("userId", (Object)userId);
                event = (EventEntity)query.getSingleResult();
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found event for id " + eventId + " and user id " + userId));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding event by id=" + eventId + " and user id=" + userId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return event;
    }

    @Transactional
    public EventEntity updateEvent(EventEntity event) {
        EventEntity mergedEvent;
        block2: {
            log.debug((Object)("start updateEvent: " + event));
            mergedEvent = null;
            try {
                mergedEvent = (EventEntity)this.em.merge((Object)event);
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception updating event: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return mergedEvent;
    }

    public List<EventEntity> findEventsByUserId(Integer userId) {
        List events;
        block2: {
            log.debug((Object)("start findEventsByUserId(" + userId + ")"));
            events = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ee from EventEntity ee ");
                inquiry.append("where ee.lanDevice.user.id = :userId ");
                inquiry.append("and ee.lanDevice.deleted = false ");
                inquiry.append("and 'ON'=(select featureValue from ProductfeatureEntity pfe where pfe.product.id = ee.lanDevice.product.id and feature.featureCode='PLAYBACK')");
                inquiry.append("and ee.deleted = false ");
                inquiry.append("order by ee.dateEvent ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                events = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding events for user id " + userId + "."));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return events;
    }

    public List<EventEntity> findEvents(Integer userId, Integer lanDeviceId, Date startRange, Date endRage) {
        List events;
        block9: {
            log.debug((Object)("start findEvents(userId=" + userId + ", lanDeviceId=" + lanDeviceId + ", startRange=" + startRange + ", endRage=" + endRage + ")"));
            events = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ee from EventEntity ee ");
                inquiry.append("where ee.lanDevice.user.id = :userId ");
                inquiry.append("and ee.lanDevice.deleted = false ");
                inquiry.append("and ee.deleted = false ");
                if (lanDeviceId != null) {
                    inquiry.append("and ee.lanDevice.lanDeviceId = :lanDeviceId ");
                } else {
                    inquiry.append("and 'ON'=(select featureValue from ProductfeatureEntity pfe where pfe.product.id = ee.lanDevice.product.id and feature.featureCode='PLAYBACK')");
                }
                if (startRange != null) {
                    inquiry.append("and ee.dateEvent >= :startRange ");
                }
                if (endRage != null) {
                    inquiry.append("and ee.dateEvent <= :endRage ");
                }
                inquiry.append("order by ee.dateEvent ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                if (lanDeviceId != null) {
                    query.setParameter("lanDeviceId", (Object)lanDeviceId);
                }
                if (startRange != null) {
                    query.setParameter("startRange", (Object)startRange);
                }
                if (endRage != null) {
                    query.setParameter("endRage", (Object)endRage);
                }
                events = query.getResultList();
            }
            catch (RuntimeException re) {
                log.error((Object)("Exception occured finding events for user id " + userId + "."));
                if (!log.isDebugEnabled()) break block9;
                re.printStackTrace();
            }
        }
        return events;
    }

    public Long countCurrentlyStoredEvents() {
        Long result;
        block2: {
            log.debug((Object)"start countCurrentlyStoredEvents()");
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select count(ee) from EventEntity ee ");
                inquiry.append("where ee.deleted = false ");
                Query query = this.em.createQuery(inquiry.toString());
                result = (Long)query.getSingleResult();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting currently sored events: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit countCurrentlyStoredEvents(): " + result));
        return result;
    }

    public Long countRecordedImageContentSize() {
        Long result;
        block2: {
            log.debug((Object)"start countRecordedImageContentSize()");
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select sum(ee.imageFileSize) from EventEntity ee ");
                inquiry.append("where ee.deleted = false ");
                Query query = this.em.createQuery(inquiry.toString());
                result = (Long)query.getSingleResult();
                result = result == null ? 0L : result;
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting recorded image consent size: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit countRecordedImageContentSize(): " + result));
        return result;
    }

    public Long countRecordedVideoContentSize() {
        Long result;
        block2: {
            log.debug((Object)"start countRecordedVideoContentSize()");
            result = 0L;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select sum(ee.videoFileSize) from EventEntity ee ");
                inquiry.append("where ee.deleted = false ");
                Query query = this.em.createQuery(inquiry.toString());
                result = (Long)query.getSingleResult();
                result = result == null ? 0L : result;
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured counting recorded video consent size: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit countRecordedVideoContentSize(): " + result));
        return result;
    }

    public Integer getMaximumSizeOfStoredVideo() {
        Integer result;
        block2: {
            log.debug((Object)"start getMaximumSizeOfStoredVideo()");
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select max(ee.videoFileSize) from EventEntity ee ");
                inquiry.append("where ee.deleted = false ");
                inquiry.append("and ee.deletedVideo = false ");
                Query query = this.em.createQuery(inquiry.toString());
                result = (Integer)query.getSingleResult();
                result = result == null ? 0 : result;
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured retrieving maximum size of stored video: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit getMaximumSizeOfStoredVideo(): " + result));
        return result;
    }

    public Double getAverageSizeOfStoredVideo() {
        Double result;
        block2: {
            log.debug((Object)"start getAverageSizeOfStoredVideo()");
            result = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select avg(ee.videoFileSize) from EventEntity ee ");
                inquiry.append("where ee.deleted = false ");
                inquiry.append("and ee.deletedVideo = false ");
                Query query = this.em.createQuery(inquiry.toString());
                result = (Double)query.getSingleResult();
                result = result == null ? 0.0 : result;
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured retrieving average size odf stored video: " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.debug((Object)("exit getAverageSizeOfStoredVideo(): " + result));
        return result;
    }

    public EventEntity findLastEventByLanDeviceId(Integer lanDeviceId) {
        List events;
        block3: {
            log.debug((Object)("start findLastEventByLanDeviceId(lanDeviceId=" + lanDeviceId + ")"));
            events = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ee from EventEntity ee ");
                inquiry.append("where ee.lanDevice.lanDeviceId = :lanDeviceId ");
                inquiry.append("order by ee.dateEvent desc ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("lanDeviceId", (Object)lanDeviceId);
                query.setFirstResult(0);
                query.setMaxResults(1);
                events = query.getResultList();
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found las event by lanDeviceId=" + lanDeviceId + "."));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding last event by lanDeviceId=" + lanDeviceId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return events.isEmpty() ? null : (EventEntity)events.get(0);
    }

    public Long sumUserVideoFileSize(Integer userId) {
        log.debug((Object)("start sumUserVideoFileSize(userId=" + userId + ")"));
        Long size = null;
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select sum(ee.videoFileSize) from EventEntity ee ");
            inquiry.append("where ee.deleted = false ");
            inquiry.append("and ee.deletedVideo = false ");
            inquiry.append("and ee.lanDevice.user.id = :userId ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("userId", (Object)userId);
            size = (Long)query.getSingleResult();
            log.debug((Object)("exit sumUserVideoFileSize(userId=" + userId + "): " + size));
            return size == null ? Long.valueOf(0L) : size;
        }
        catch (RuntimeException re) {
            log.error((Object)("Error suming size of video files for userId=" + userId + ": " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return null;
        }
    }

    public Long sumDeviceVideoFileSize(Integer lanDeviceId) {
        log.debug((Object)("start sumDeviceVideoFileSize(lanDeviceId=" + lanDeviceId + ")"));
        Long size = null;
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select sum(ee.videoFileSize) from EventEntity ee ");
            inquiry.append("where ee.deleted = false ");
            inquiry.append("and ee.deletedVideo = false ");
            inquiry.append("and ee.lanDevice.lanDeviceId = :lanDeviceId ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("lanDeviceId", (Object)lanDeviceId);
            size = (Long)query.getSingleResult();
            log.debug((Object)("exit sumDeviceVideoFileSize(lanDeviceId=" + lanDeviceId + "): " + size));
            return size == null ? Long.valueOf(0L) : size;
        }
        catch (RuntimeException re) {
            log.error((Object)("Error suming size of video files for lanDeviceId=" + lanDeviceId + ": " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return null;
        }
    }

    public Long countUserEvents(Integer userId) {
        log.debug((Object)("start countUserEvents(userId=" + userId + ")"));
        Long count = null;
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select count(ee) from EventEntity ee ");
            inquiry.append("where ee.deleted = false ");
            inquiry.append("and ee.lanDevice.user.id = :userId ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("userId", (Object)userId);
            count = (Long)query.getSingleResult();
            log.debug((Object)("exit countEvents(userId=" + userId + "): " + count));
            return count == null ? Long.valueOf(0L) : count;
        }
        catch (RuntimeException re) {
            log.error((Object)("Error counting events for userId=" + userId + ": " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return null;
        }
    }

    public Long countDeviceEvents(Integer lanDeviceId) {
        log.debug((Object)("start countDeviceEvents(lanDeviceId=" + lanDeviceId + ")"));
        Long count = null;
        try {
            StringBuilder inquiry = new StringBuilder();
            inquiry.append("select count(ee) from EventEntity ee ");
            inquiry.append("where ee.deleted = false ");
            inquiry.append("and ee.lanDevice.lanDeviceId = :lanDeviceId ");
            Query query = this.em.createQuery(inquiry.toString());
            query.setParameter("lanDeviceId", (Object)lanDeviceId);
            count = (Long)query.getSingleResult();
            log.debug((Object)("exit countDeviceEvents(lanDeviceId=" + lanDeviceId + "): " + count));
            return count == null ? Long.valueOf(0L) : count;
        }
        catch (RuntimeException re) {
            log.error((Object)("Error counting events for lanDeviceId=" + lanDeviceId + ": " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return null;
        }
    }

    public List<EventEntity> findUserEventsWithVideo(Integer userId) {
        block3: {
            log.debug((Object)("start findUserEventsWithVideo(userId=" + userId + ")"));
            List events = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ee from EventEntity ee ");
                inquiry.append("where ee.lanDevice.user.id = :userId ");
                inquiry.append("and ee.videoFileSize <> NULL ");
                inquiry.append("and ee.videoFileSize > 0 ");
                inquiry.append("and ee.deletedVideo = false ");
                inquiry.append("and ee.deleted = false ");
                inquiry.append("order by ee.dateEvent asc ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                events = query.getResultList();
                return events;
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found any events with video by userId=" + userId + "."));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding events with video by userId=" + userId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return null;
    }

    public List<EventEntity> findDeviceEventsWithVideo(Integer lanDeviceId) {
        block3: {
            log.debug((Object)("start findDeviceEventsWithVideo(lanDeviceId=" + lanDeviceId + ")"));
            List events = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ee from EventEntity ee ");
                inquiry.append("where ee.lanDevice.lanDeviceId = :lanDeviceId ");
                inquiry.append("and ee.videoFileSize <> NULL ");
                inquiry.append("and ee.videoFileSize > 0 ");
                inquiry.append("and ee.deletedVideo = false ");
                inquiry.append("and ee.deleted = false ");
                inquiry.append("order by ee.dateEvent asc ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("lanDeviceId", (Object)lanDeviceId);
                events = query.getResultList();
                return events;
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found any events with video by lanDeviceId=" + lanDeviceId + "."));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding events with video by lanDeviceId=" + lanDeviceId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return null;
    }

    public List<EventEntity> findDeviceDeletedEventsWithVideo(Integer lanDeviceId) {
        block3: {
            log.debug((Object)("start findDeviceEventsWithVideo(lanDeviceId=" + lanDeviceId + ")"));
            List events = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ee from EventEntity ee ");
                inquiry.append("where ee.lanDevice.lanDeviceId = :lanDeviceId ");
                inquiry.append("and ee.videoFileSize <> NULL ");
                inquiry.append("and ee.videoFileSize > 0 ");
                inquiry.append("and ee.deletedVideo = false ");
                inquiry.append("and ee.deleted = true ");
                inquiry.append("order by ee.dateEvent asc ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("lanDeviceId", (Object)lanDeviceId);
                events = query.getResultList();
                return events;
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found any events with video by lanDeviceId=" + lanDeviceId + "."));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding events with video by lanDeviceId=" + lanDeviceId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return null;
    }

    public List<EventEntity> findUserEvents(Integer userId, Integer limit) {
        block3: {
            log.debug((Object)("start findEvents(userId=" + userId + ", limit=" + limit + ")"));
            List events = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ee from EventEntity ee ");
                inquiry.append("where ee.lanDevice.user.id = :userId ");
                inquiry.append("and ee.deleted = false ");
                inquiry.append("order by ee.dateEvent asc ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("userId", (Object)userId);
                query.setFirstResult(0);
                query.setMaxResults(limit.intValue());
                events = query.getResultList();
                return events;
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found any events for userId=" + userId + "."));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding events for userId=" + userId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return null;
    }

    public List<EventEntity> findDeviceEvents(Integer lanDeviceId, Integer limit) {
        block3: {
            log.debug((Object)("start findDeviceEvents(lanDeviceId=" + lanDeviceId + ", limit=" + limit + ")"));
            List events = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select ee from EventEntity ee ");
                inquiry.append("where ee.lanDevice.lanDeviceId = :lanDeviceId ");
                inquiry.append("and ee.deleted = false ");
                inquiry.append("order by ee.dateEvent asc ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("lanDeviceId", (Object)lanDeviceId);
                query.setFirstResult(0);
                query.setMaxResults(limit.intValue());
                events = query.getResultList();
                return events;
            }
            catch (NoResultException nre) {
                log.debug((Object)("Not found any events for lanDeviceId=" + lanDeviceId + "."));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error finding events for lanDeviceId=" + lanDeviceId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return null;
    }

    public EventEntity getActiveEvent(Integer lanDeviceId) {
        EventEntity event;
        block3: {
            log.info((Object)("start getActiveEvent(lanDeviceId=" + lanDeviceId + ")"));
            event = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select e from EventEntity e ");
                inquiry.append("where e.lanDevice.lanDeviceId = :lanDeviceId ");
                inquiry.append("and e.deleted = false ");
                inquiry.append("and e.dateStopRequested is not null ");
                inquiry.append("and e.dateStopRequested > :now ");
                inquiry.append("and e.dateStopped is null ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("lanDeviceId", (Object)lanDeviceId);
                query.setParameter("now", (Object)new Date());
                event = (EventEntity)query.getSingleResult();
            }
            catch (NoResultException e) {
                log.debug((Object)("No active event found for device with lanDeviceId=" + lanDeviceId + "."));
            }
            catch (RuntimeException re) {
                log.error((Object)("Error getting active event for lan device wit laDeviceId=" + lanDeviceId + ": " + re.getMessage() + "."));
                if (!log.isDebugEnabled()) break block3;
                re.printStackTrace();
            }
        }
        log.info((Object)("end getActiveEvent(lanDeviceId=" + lanDeviceId + "): " + event + "."));
        return event;
    }

    @Transactional
    public int setEventsAsDeleted(List<Integer> eventIds) {
        int updated;
        block2: {
            log.info((Object)("start setEventsAsDeleted(eventIds=" + eventIds.toString() + ")"));
            updated = 0;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("update EventEntity e ");
                inquiry.append("set e.deleted = true ");
                inquiry.append("where e.eventId in ( :eventIds ) ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("eventIds", eventIds);
                updated = query.executeUpdate();
            }
            catch (RuntimeException re) {
                log.error((Object)"Error setting events as deleted");
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        log.info((Object)("end setEventsAsDeleted(eventIds=" + eventIds.toString() + ")"));
        return updated;
    }
}

