/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;
import pl.smartapps.restserver.db.main.EmailTemplateEntity;

@Repository
public class EmailTemplateDAO {
    private static Logger log = Logger.getLogger(EmailTemplateDAO.class);
    @PersistenceContext
    private EntityManager em;

    public EmailTemplateEntity findEmailTemplateByEmailCodeAnLanguage(String emailCode, String language) {
        EmailTemplateEntity emailTemplate;
        block4: {
            log.debug((Object)("start findEmailTemplateByEmailCodeAnLanguage(emailCode=" + emailCode + ", language=" + language + ")"));
            emailTemplate = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select et from EmailTemplateEntity et ");
                inquiry.append("where et.emailCode = :emailCode ");
                inquiry.append("and et.language = :language ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("emailCode", (Object)emailCode);
                query.setParameter("language", (Object)language);
                emailTemplate = (EmailTemplateEntity)query.getSingleResult();
            }
            catch (NonUniqueResultException nure) {
                log.error((Object)("Found more than one email template for emailCode=" + emailCode + " and language=" + language + "."));
            }
            catch (NoResultException nre) {
                log.info((Object)("No email template found for emailCode=" + emailCode + " and language=" + language + "."));
            }
            catch (IllegalStateException ise) {
                log.error((Object)("Exception occured finding email template for emailCode=" + emailCode + " and language=" + language + "."));
                if (!log.isDebugEnabled()) break block4;
                ise.printStackTrace();
            }
        }
        log.debug((Object)("exit findEmailTemplateByEmailCodeAnLanguage(emailCode=" + emailCode + ", language=" + language + "): " + emailTemplate + "."));
        return emailTemplate;
    }
}

