/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;
import pl.smartapps.restserver.db.main.DyndnsEntity;
import pl.smartapps.restserver.util.ErrorMessages;
import pl.smartapps.restserver.util.ExceptionsTrigger;

@Repository
public class DyndnsDAO {
    private static Logger log = Logger.getLogger(DyndnsDAO.class);
    @PersistenceContext
    private EntityManager em;

    public DyndnsEntity store(DyndnsEntity dyndns, boolean merge) {
        if (dyndns == null) {
            log.error((Object)"Store null entity request");
            return null;
        }
        try {
            if (merge) {
                return (DyndnsEntity)this.em.merge((Object)dyndns);
            }
            this.em.persist((Object)dyndns);
            return dyndns;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.STORE_ENTITY_EXCEPTION((Object)dyndns, (Exception)ex));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public DyndnsEntity getDyndnsByDomainName(String domainName) {
        ExceptionsTrigger.throwIfNull((Object)domainName, (RuntimeException)new NullPointerException("domainName"));
        try {
            TypedQuery query = this.em.createNamedQuery("DyndnEntity.FIND_BY_DOMAIN_NAME", DyndnsEntity.class);
            query.setParameter("domainName", (Object)domainName);
            return (DyndnsEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"DyndnEntity.FIND_BY_DOMAIN_NAME", (String)"select d from DyndnsEntity d where d.domainName = :domainName", (Exception)ex));
            throw ex;
        }
    }

    public DyndnsEntity getDyndnsByHaId(String haId) {
        ExceptionsTrigger.throwIfNull((Object)haId, (RuntimeException)new NullPointerException("haId"));
        try {
            TypedQuery query = this.em.createNamedQuery("DyndnEntity.FIND_BY_HAID", DyndnsEntity.class);
            query.setParameter("haId", (Object)haId);
            return (DyndnsEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"DyndnEntity.FIND_BY_HAID", (String)"select d from DyndnsEntity d where d.haId = :haId", (Exception)ex));
            throw ex;
        }
    }
}

