/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.util.ErrorMessages;

@Repository
public class DeviceDescDAO {
    private static Logger log = Logger.getLogger(DeviceDescDAO.class);
    @PersistenceContext
    private EntityManager em;

    public DeviceDescEntity store(DeviceDescEntity entity) {
        if (entity == null) {
            log.error((Object)"Store null entity request");
            return null;
        }
        try {
            if (entity.getDeviceDescId() != null) {
                return (DeviceDescEntity)this.em.merge((Object)entity);
            }
            this.em.persist((Object)entity);
            return entity;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.STORE_ENTITY_EXCEPTION((Object)entity, (Exception)ex));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public DeviceDescEntity findDeviceDescById(Integer deviceDescId) {
        DeviceDescEntity deviceDesc;
        block2: {
            log.debug((Object)("start findDeviceDescById(" + deviceDescId + ")"));
            deviceDesc = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select dd from DeviceDescEntity dd ");
                inquiry.append("where dd.deviceDescId = :deviceDescId");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("deviceDescId", (Object)deviceDescId);
                deviceDesc = (DeviceDescEntity)query.getSingleResult();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured during finding device desc for deviceDescId=" + deviceDescId + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return deviceDesc;
    }

    public DeviceDescEntity findDeviceDesc(String classDevice, String make, String model, String driverclass) {
        DeviceDescEntity deviceDesc;
        block2: {
            log.debug((Object)("start findDeviceDescByDriverClass(" + classDevice + "," + make + "," + model + "," + driverclass + ")"));
            deviceDesc = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select dd from DeviceDescEntity dd ");
                inquiry.append("where dd.classDevice = :classDevice ");
                inquiry.append("and dd.make = :make ");
                inquiry.append("and dd.model = :model ");
                inquiry.append("and dd.driverclass = :driverclass");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("classDevice", (Object)classDevice);
                query.setParameter("make", (Object)make);
                query.setParameter("model", (Object)model);
                query.setParameter("driverclass", (Object)driverclass);
                deviceDesc = (DeviceDescEntity)query.getSingleResult();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured during finding device desc for classDevice=" + classDevice + ", make=" + make + ", driverclass=" + driverclass + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return deviceDesc;
    }

    public DeviceDescEntity findDeviceDesc(String classDevice, String make, String model) {
        DeviceDescEntity deviceDesc;
        block3: {
            log.debug((Object)("start findDeviceDesc(classDevice=" + classDevice + ", make=" + make + ", model=" + model + ")"));
            deviceDesc = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select dd from DeviceDescEntity dd ");
                inquiry.append("where dd.classDevice = :classDevice ");
                inquiry.append("and dd.make = :make ");
                inquiry.append("and dd.model = :model ");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("classDevice", (Object)classDevice);
                query.setParameter("make", (Object)make);
                query.setParameter("model", (Object)model);
                deviceDesc = (DeviceDescEntity)query.getSingleResult();
            }
            catch (NoResultException ex) {
                return null;
            }
            catch (RuntimeException re) {
                log.info((Object)("Error occured during finding devicedesc for classDevice=" + classDevice + ", make=" + make + ", model=" + model + ": " + re.getMessage()));
                if (!log.isTraceEnabled()) break block3;
                re.printStackTrace();
            }
        }
        return deviceDesc;
    }

    public DeviceDescEntity findDeviceDescByDriverclass(String driverclass) {
        DeviceDescEntity deviceDesc;
        block2: {
            log.debug((Object)("start findDeviceDescByDriverclass(" + driverclass + ")"));
            deviceDesc = null;
            try {
                StringBuilder inquiry = new StringBuilder();
                inquiry.append("select dd from DeviceDescEntity dd ");
                inquiry.append("where dd.driverclass = :driverclass");
                Query query = this.em.createQuery(inquiry.toString());
                query.setParameter("driverclass", (Object)driverclass);
                deviceDesc = (DeviceDescEntity)query.getSingleResult();
            }
            catch (RuntimeException re) {
                log.error((Object)("Error occured during finding device desc for driverclass=" + driverclass + ": " + re.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                re.printStackTrace();
            }
        }
        return deviceDesc;
    }
}

