/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import pl.smartapps.restserver.db.dao.DeviceDescDAO;
import pl.smartapps.restserver.db.main.DebuglogEntity;

@Repository
public class DebuglogDAO {
    private static Logger log = Logger.getLogger(DeviceDescDAO.class);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private JpaTransactionManager txManager;

    public DebuglogEntity createDebuglog(DebuglogEntity debuglog) {
        log.debug((Object)("start saveDebuglog(debuglog=" + debuglog + ")"));
        try {
            this.em.persist((Object)debuglog);
            return debuglog;
        }
        catch (RuntimeException re) {
            log.error((Object)("Exception updating debuglog: " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return null;
        }
    }

    public DebuglogEntity updateDebuglog(DebuglogEntity debuglog) {
        log.debug((Object)("start updateDebuglog(debuglog=" + debuglog + ")"));
        try {
            return (DebuglogEntity)this.em.merge((Object)debuglog);
        }
        catch (RuntimeException re) {
            log.error((Object)("Exception updating debuglog: " + re.getMessage()));
            if (log.isDebugEnabled()) {
                re.printStackTrace();
            }
            return null;
        }
    }

    public DebuglogEntity createDebuglogWithTransaction(DebuglogEntity debuglog) {
        log.debug((Object)("start createDebuglogWithTransaction(debuglog=" + debuglog + "."));
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("createDebuglog transaction");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        DebuglogEntity result = this.createDebuglog(debuglog);
        this.txManager.commit(status);
        return result;
    }
}

