/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.dao;

import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;
import pl.smartapps.restserver.db.main.ApplicationEntity;
import pl.smartapps.restserver.service.DeviceType;
import pl.smartapps.restserver.util.ErrorMessages;

@Repository
public class ApplicationDAO {
    private static Logger log = Logger.getLogger(ApplicationDAO.class);
    @PersistenceContext
    private EntityManager em;

    public ApplicationEntity store(ApplicationEntity entity) {
        if (entity == null) {
            log.error((Object)"Store null entity request");
            return null;
        }
        try {
            if (entity.getApplicationId() != null) {
                return (ApplicationEntity)this.em.merge((Object)entity);
            }
            this.em.persist((Object)entity);
            return entity;
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.STORE_ENTITY_EXCEPTION((Object)entity, (Exception)ex));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public ApplicationEntity getApplicationById(Integer id) {
        if (id != null) {
            return (ApplicationEntity)this.em.find(ApplicationEntity.class, (Object)id);
        }
        return null;
    }

    public List<ApplicationEntity> getByDeviceType(DeviceType deviceType) {
        if (deviceType == null) {
            log.error((Object)ErrorMessages.FIND_BY_NULL_ID_REQUEST);
            return Collections.emptyList();
        }
        try {
            TypedQuery query = this.em.createNamedQuery("ApplicationEntity.FIND_BY_DEVICE_TYPE", ApplicationEntity.class);
            query.setParameter("deviceType", (Object)deviceType);
            return query.getResultList();
        }
        catch (RuntimeException ex) {
            log.error((Object)ErrorMessages.DB_QUERY_EXECUTION_FAIL((String)"ApplicationEntity.FIND_BY_DEVICE_TYPE", (String)"select a from ApplicationEntity a where a.deviceType =:deviceType", (Exception)ex));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }
}

