/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.shared.validation;

import com.google.gwt.user.client.ui.HasText;
import eu.maydu.gwt.validation.client.ValidationAction;
import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.Validator;
import eu.maydu.gwt.validation.client.i18n.StandardValidationMessages;
import eu.maydu.gwt.validation.client.i18n.ValidationMessages;

public class TrimmedStringLengthValidator
extends Validator<TrimmedStringLengthValidator> {
    private final HasText hasText;
    private int min;
    private int max;
    private boolean trimFirst;

    public TrimmedStringLengthValidator(HasText hasText) {
        this(hasText, false);
    }

    public TrimmedStringLengthValidator(HasText hasText, int min, int max) {
        this(hasText, min, max, false);
    }

    public TrimmedStringLengthValidator(HasText hasText, boolean preventsPropagationOfValidationChain) {
        this(hasText, preventsPropagationOfValidationChain, null);
    }

    public TrimmedStringLengthValidator(HasText hasText, boolean preventsPropagationOfValidationChain, String customMsgKey) {
        this(hasText, 0, Integer.MAX_VALUE, preventsPropagationOfValidationChain, customMsgKey);
    }

    public TrimmedStringLengthValidator(HasText hasText, int min, int max, boolean preventsPropagationOfValidationChain) {
        this(hasText, min, max, preventsPropagationOfValidationChain, null);
    }

    public TrimmedStringLengthValidator(HasText hasText, int min, int max, boolean preventsPropagationOfValidationChain, String customMsgKey) {
        if (hasText == null) {
            throw new IllegalArgumentException("hasText must not be null");
        }
        this.hasText = hasText;
        this.setPreventsPropagationOfValidationChain(preventsPropagationOfValidationChain);
        this.setMin(min);
        this.setMax(max);
        this.setTrimFirst(true);
        this.setCustomMsgKey(customMsgKey);
    }

    public ValidationResult validate(ValidationMessages allMessages) {
        StandardValidationMessages messages = allMessages.getStandardMessages();
        String str = this.hasText.getText();
        if (this.trimFirst) {
            str = str.trim();
        }
        if (str.equals("") && !this.isRequired()) {
            return null;
        }
        int len = str.length();
        if (len < this.min || len > this.max) {
            return new ValidationResult(this.getErrorMessage(allMessages, messages.length(this.min, this.max, len), new Object[]{this.min, this.max, len}));
        }
        return null;
    }

    public void invokeActions(ValidationResult result) {
        if (this.hasText != null) {
            for (ValidationAction action : this.getFailureActions()) {
                action.invoke(result, (Object)this.hasText);
            }
        }
    }

    public TrimmedStringLengthValidator setMin(int min) {
        this.min = min;
        return this;
    }

    public TrimmedStringLengthValidator setMax(int max) {
        this.max = max;
        return this;
    }

    public TrimmedStringLengthValidator setTrimFirst(boolean trimFirst) {
        this.trimFirst = trimFirst;
        return this;
    }
}

