/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.shared.validation;

import com.google.gwt.user.client.ui.HasText;
import eu.maydu.gwt.validation.client.ValidationAction;
import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.Validator;
import eu.maydu.gwt.validation.client.i18n.ValidationMessages;

public class EmailAddressValidator
extends Validator<EmailAddressValidator> {
    private final HasText hasText;
    private boolean trimFirst;
    private static final String EMAIL_PATTERN = "^([\\w\\!\\#$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\`{\\|\\}\\~]+\\.)*[\\w\\!\\#$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\`{\\|\\}\\~]+@((((([a-zA-Z0-9]{1}[a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9]{1})|[a-zA-Z])\\.)+[a-zA-Z]{2,6})|(\\d{1,3}\\.){3}\\d{1,3}(\\:\\d{1,5})?)$";

    public EmailAddressValidator(HasText hasText) {
        this(hasText, false);
    }

    public EmailAddressValidator(HasText hasText, boolean preventsPropagationOfValidationChain) {
        this(hasText, preventsPropagationOfValidationChain, null);
    }

    public EmailAddressValidator(HasText hasText, boolean preventsPropagationOfValidationChain, String customMsgKey) {
        if (hasText == null) {
            throw new IllegalArgumentException("hasText must not be null");
        }
        this.hasText = hasText;
        this.setPreventsPropagationOfValidationChain(preventsPropagationOfValidationChain);
        this.setTrimFirst(true);
        this.setCustomMsgKey(customMsgKey);
    }

    public ValidationResult validate(ValidationMessages allMessages) {
        String str = this.hasText.getText();
        if (this.trimFirst) {
            str = str.trim();
        }
        if (str.equals("") && !this.isRequired()) {
            return null;
        }
        if (!str.matches(EMAIL_PATTERN)) {
            return new ValidationResult(this.getErrorMessage(allMessages, allMessages.getCustomMessage("INVALID_FORMAT", new Object[0]), new Object[0]));
        }
        return null;
    }

    public void invokeActions(ValidationResult result) {
        if (this.hasText != null) {
            for (ValidationAction action : this.getFailureActions()) {
                action.invoke(result, (Object)this.hasText);
            }
        }
    }

    public EmailAddressValidator setTrimFirst(boolean trimFirst) {
        this.trimFirst = trimFirst;
        return this;
    }
}

