/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.support;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.Serializable;
import java.util.concurrent.Callable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.customware.gwt.dispatch.client.secure.SecureDispatchService;
import net.customware.gwt.dispatch.server.Dispatch;
import net.customware.gwt.dispatch.shared.Action;
import net.customware.gwt.dispatch.shared.DispatchException;
import net.customware.gwt.dispatch.shared.Result;
import net.customware.gwt.dispatch.shared.ServiceException;
import nl.captcha.Captcha;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ShiroSecureDispatchServlet
extends RemoteServiceServlet
implements SecureDispatchService {
    private SecurityManager securityManager;
    private Dispatch dispatch;
    public static ThreadLocal<Captcha> threadLocalCaptcha;
    public static ThreadLocal<String> threadLocalClientIpAddress;

    @Autowired
    @Required
    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    protected Dispatch getDispatch() {
        return this.dispatch;
    }

    @Autowired
    @Required
    public void setDispatch(Dispatch dispatch) {
        this.dispatch = dispatch;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)config.getServletContext());
        AutowireCapableBeanFactory beanFactory = ctx.getAutowireCapableBeanFactory();
        beanFactory.autowireBean((Object)this);
        threadLocalCaptcha = new ThreadLocal();
        threadLocalClientIpAddress = new ThreadLocal();
    }

    public Result execute(String sessionId, Action<?> action) throws DispatchException {
        try {
            SecurityManager securityManager = this.securityManager != null ? this.securityManager : SecurityUtils.getSecurityManager();
            Subject.Builder builder = new Subject.Builder(securityManager);
            builder.sessionId((Serializable)((Object)sessionId));
            Subject subject = builder.buildSubject();
            threadLocalClientIpAddress.set(this.getThreadLocalRequest().getRemoteAddr());
            Session session = subject.getSession();
            if (session != null) {
                threadLocalCaptcha.set((Captcha)session.getAttribute((Object)"simpleCaptcha"));
            }
            Callable associated = subject.associateWith((Callable)new /* Unavailable Anonymous Inner Class!! */);
            Result result = (Result)associated.call();
            return result;
        }
        catch (DispatchException e) {
            throw e;
        }
        catch (Exception e) {
            this.log("Exception while executing " + action.getClass().getName() + ": " + e.getMessage(), (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }
}

