/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.VerifyPasswordStatus;
import pl.smartapps.hm.WebViewer.shared.rpc.VerifyPassword;
import pl.smartapps.hm.WebViewer.shared.rpc.VoidResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.UserServiceExt;

@ActionHandlerBean
public class VerifyPasswordHandler
implements ActionHandler<VerifyPassword, VoidResult> {
    @Autowired
    private UserServiceExt userService;

    public VoidResult execute(VerifyPassword action, ExecutionContext context) throws ActionException {
        Log.info((String)("> VerifyPassword::Request: " + action.getPassword()));
        try {
            VerifyPasswordStatus response = this.userService.verifyPassword(action.getPassword());
            Log.info((String)("< VerifyPassword::Response: " + response.toString()));
            if (response != VerifyPasswordStatus.CORRECT) {
                ServerValidation.exception((String)("VERIFY_PASSWORD_STATUS_" + response.toString()), (String)"", (Object[])new Object[0]);
            }
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        return VoidResult.VOID;
    }

    public void rollback(VerifyPassword action, VoidResult result, ExecutionContext context) throws ActionException {
    }

    public Class<VerifyPassword> getActionType() {
        return VerifyPassword.class;
    }
}

