/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.VerifyLANDevice;
import pl.smartapps.hm.WebViewer.shared.rpc.VerifyLANDeviceResult;
import pl.smartapps.restserver.rest.response.DeviceVerificationResponse;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class VerifyLANDeviceHandler
implements ActionHandler<VerifyLANDevice, VerifyLANDeviceResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public VerifyLANDeviceResult execute(VerifyLANDevice action, ExecutionContext context) throws ActionException {
        Log.info((String)("> VerifyLANDevice::Request: " + action.getGcId() + " " + action.getAddress() + " " + action.getMac() + action.getDeviceDescId()));
        DeviceVerificationResponse response = new DeviceVerificationResponse();
        try {
            response = this.lanDeviceService.verifyDiscoveredLanDevice(Integer.valueOf(action.getGcId()), action.getMac(), action.getAddress(), action.getDeviceDescId());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< VerifyLANDevice::Response: " + response.status.toString() + response.lanDevice.toString()));
        if (response.status != DeviceVerificationResponse.DeviceVerificationStatus.OK) {
            String key = "ACCESS_VERIFICATION_STATUS_" + response.status.toString();
            ServerValidation.exception((String)key, (String)"", (Object[])new Object[0]);
        }
        VerifyLANDeviceResult result = new VerifyLANDeviceResult();
        result.setLd(response.lanDevice);
        return result;
    }

    public void rollback(VerifyLANDevice action, VerifyLANDeviceResult result, ExecutionContext context) throws ActionException {
    }

    public Class<VerifyLANDevice> getActionType() {
        return VerifyLANDevice.class;
    }
}

