/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.ValidateCameraActivationCode;
import pl.smartapps.hm.WebViewer.shared.rpc.ValidateCameraActivationCodeResult;
import pl.smartapps.hm.WebViewer.shared.validation.ValidationPropertyEnum;
import pl.smartapps.restserver.rest.response.VerifyGcResponse;
import pl.smartapps.restserver.service.ext.GatewayClientServiceExt;
import pl.smartapps.restserver.service.ext.InvalidSessionException;

@ActionHandlerBean
public class ValidateCameraActivationCodeHandler
implements ActionHandler<ValidateCameraActivationCode, ValidateCameraActivationCodeResult> {
    @Autowired
    private GatewayClientServiceExt gatewayClientService;

    public ValidateCameraActivationCodeResult execute(ValidateCameraActivationCode action, ExecutionContext context) throws ActionException {
        String activationCode = action.getActivationCode();
        Log.info((String)("> ValidateCameraActivationCode::Request: " + activationCode));
        VerifyGcResponse response = null;
        try {
            response = this.gatewayClientService.verifyGatewayClient(activationCode);
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< ValidateCameraActivationCode::Response: " + response.status.toString()));
        if (response.status != VerifyGcResponse.VerifyGcStatus.SUCCESS) {
            if (response.status == VerifyGcResponse.VerifyGcStatus.FAILED_CODEINCORRECT) {
                ServerValidation.exception((String)("ACTIVATE_STATUS_" + response.status.toString()), (String)ValidationPropertyEnum.ACTIVATION_CODE.toString(), (Object[])new Object[0]);
            } else {
                ServerValidation.exception((String)("ACTIVATE_STATUS_" + response.status.toString()), (String)"", (Object[])new Object[0]);
            }
        }
        ValidateCameraActivationCodeResult result = new ValidateCameraActivationCodeResult();
        result.setConnected(response.status == VerifyGcResponse.VerifyGcStatus.SUCCESS);
        result.setUsername(response.username);
        result.setPassword(response.password);
        return result;
    }

    public void rollback(ValidateCameraActivationCode action, ValidateCameraActivationCodeResult result, ExecutionContext context) throws ActionException {
    }

    public Class<ValidateCameraActivationCode> getActionType() {
        return ValidateCameraActivationCode.class;
    }
}

