/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.ValidateActivationCode;
import pl.smartapps.hm.WebViewer.shared.rpc.VoidResult;
import pl.smartapps.hm.WebViewer.shared.validation.ValidationPropertyEnum;
import pl.smartapps.restserver.rest.response.ActivateGcResponse;
import pl.smartapps.restserver.service.ext.GatewayClientServiceExt;
import pl.smartapps.restserver.service.ext.InvalidSessionException;

@ActionHandlerBean
public class ValidateActivationCodeHandler
implements ActionHandler<ValidateActivationCode, VoidResult> {
    @Autowired
    private GatewayClientServiceExt gatewayClientService;

    public VoidResult execute(ValidateActivationCode action, ExecutionContext context) throws ActionException {
        String activationCode = action.getActivationCode();
        Log.info((String)("> ValidateActivationCode::Request: " + action.getActivationCode()));
        ActivateGcResponse response = new ActivateGcResponse();
        try {
            response = this.gatewayClientService.activeteGatewaClient(activationCode);
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< ValidateActivationCode::Response: " + response.status.toString() + " " + (response.gatewayClient == null ? "null" : response.gatewayClient.toString())));
        if (response.status != ActivateGcResponse.ActivateStatus.SUCCESS) {
            ServerValidation.exception((String)("ACTIVATE_STATUS_" + response.status.toString()), (String)ValidationPropertyEnum.ACTIVATION_CODE.toString(), (Object[])new Object[0]);
        }
        return VoidResult.VOID;
    }

    public void rollback(ValidateActivationCode action, VoidResult result, ExecutionContext context) throws ActionException {
    }

    public Class<ValidateActivationCode> getActionType() {
        return ValidateActivationCode.class;
    }
}

