/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.UpgradeFirmwareStatus;
import pl.smartapps.hm.WebViewer.shared.rpc.UpgradeFirmware;
import pl.smartapps.hm.WebViewer.shared.rpc.VoidResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class UpgradeFirmwareHandler
implements ActionHandler<UpgradeFirmware, VoidResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public VoidResult execute(UpgradeFirmware action, ExecutionContext context) throws ActionException {
        UpgradeFirmwareStatus response = null;
        Log.info((String)("> UpgradeFirmware::Request: " + action.getLanDeviceId().toString()));
        try {
            response = this.lanDeviceService.upgradeFirmware(action.getLanDeviceId());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< UpgradeFirmware::Response: " + response));
        if (response != UpgradeFirmwareStatus.SUCCESS) {
            if (response == UpgradeFirmwareStatus.FAILED_DEVICEDISCONNECTED || response == UpgradeFirmwareStatus.FAILED_FIRMWAREISUPTODATE) {
                ServerValidation.exception((String)("UPGRADE_FIRMWARE_STATUS_" + response.toString()), (String)"", (Object[])new Object[0]);
            } else {
                ServerValidation.exception((String)"UPGRADE_FIRMWARE_STATUS_ERROR", (String)"", (Object[])new Object[0]);
            }
        }
        return VoidResult.VOID;
    }

    public void rollback(UpgradeFirmware action, VoidResult result, ExecutionContext context) throws ActionException {
    }

    public Class<UpgradeFirmware> getActionType() {
        return UpgradeFirmware.class;
    }
}

