/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.UpdateDeviceProductResponse;
import pl.smartapps.hm.WebViewer.shared.rpc.UpdateDeviceProduct;
import pl.smartapps.hm.WebViewer.shared.rpc.UpdateDeviceProductResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class UpdateDeviceProductHandler
implements ActionHandler<UpdateDeviceProduct, UpdateDeviceProductResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public UpdateDeviceProductResult execute(UpdateDeviceProduct action, ExecutionContext context) throws ActionException {
        Log.debug((String)("> UpdateDeviceProduct::Request:  " + action.getLanDeviceId() + action.getProductType().toString()));
        UpdateDeviceProductResponse response = null;
        try {
            response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(action.getLanDeviceId()), action.getProductType());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.debug((String)("< UpdateDeviceProduct::Response: " + response.toString()));
        if (response.getStatus() != UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS) {
            ServerValidation.exception((String)"UPDATE_DEVICE_PRODUCT_STATUS_FAILED", (String)"", (Object[])new Object[0]);
        }
        UpdateDeviceProductResult result = new UpdateDeviceProductResult();
        result.setProductType(response.getProductType());
        result.setTrialDateValidFrom(response.getValidTo());
        result.setProductName(null);
        return result;
    }

    public void rollback(UpdateDeviceProduct action, UpdateDeviceProductResult result, ExecutionContext context) throws ActionException {
    }

    public Class<UpdateDeviceProduct> getActionType() {
        return UpdateDeviceProduct.class;
    }
}

