/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.UnshareDeviceResponse;
import pl.smartapps.hm.WebViewer.shared.rpc.UnshareDevice;
import pl.smartapps.hm.WebViewer.shared.rpc.UnshareDeviceResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class UnshareDeviceHandler
implements ActionHandler<UnshareDevice, UnshareDeviceResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public UnshareDeviceResult execute(UnshareDevice action, ExecutionContext context) throws ActionException {
        Log.info((String)("> UnshareDevice::Request: lanDeviceId = " + action.getLanDeviceId() + ", email = " + action.getEmail()));
        UnshareDeviceResponse response = null;
        try {
            response = this.lanDeviceService.unshareLanDevice(action.getLanDeviceId(), action.getEmail());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< UnshareDevice::Response: " + response.status.toString()));
        if (response.status != UnshareDeviceResponse.UnshareDeviceStatus.SUCCESS && response.status != UnshareDeviceResponse.UnshareDeviceStatus.FAILED_EMAILPROBLEM) {
            ServerValidation.exception((String)("UNSHARE_DEVICE_STATUS_" + response.status.toString()), (String)"", (Object[])new Object[0]);
        }
        UnshareDeviceResult result = new UnshareDeviceResult();
        result.setStatus(response.status);
        return result;
    }

    public void rollback(UnshareDevice action, UnshareDeviceResult result, ExecutionContext context) throws ActionException {
    }

    public Class<UnshareDevice> getActionType() {
        return UnshareDevice.class;
    }
}

