/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.DeviceSharedWithResponse;
import pl.smartapps.hm.WebViewer.shared.rpc.SharedWith;
import pl.smartapps.hm.WebViewer.shared.rpc.SharedWithResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class SharedWithHandler
implements ActionHandler<SharedWith, SharedWithResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public SharedWithResult execute(SharedWith action, ExecutionContext context) throws ActionException {
        Log.info((String)("> SharedWith::Request: lanDeviceId = " + action.getLanDeviceId()));
        DeviceSharedWithResponse response = null;
        try {
            response = this.lanDeviceService.getDeviceSharedWith(action.getLanDeviceId());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< SharedWith::Response: " + response.status.toString()));
        if (response.status != DeviceSharedWithResponse.DeviceSharedWithStatus.SUCCESS) {
            ServerValidation.exception((String)("SHARED_WITH_STATUS_" + response.status.toString()), (String)"", (Object[])new Object[0]);
        }
        SharedWithResult result = new SharedWithResult();
        result.setStatus(response.status);
        result.setUsers(response.users);
        return result;
    }

    public void rollback(SharedWith action, SharedWithResult result, ExecutionContext context) throws ActionException {
    }

    public Class<SharedWith> getActionType() {
        return SharedWith.class;
    }
}

