/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.ShareDeviceResponse;
import pl.smartapps.hm.WebViewer.shared.rpc.ShareDevice;
import pl.smartapps.hm.WebViewer.shared.rpc.ShareDeviceResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class ShareDeviceHandler
implements ActionHandler<ShareDevice, ShareDeviceResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public ShareDeviceResult execute(ShareDevice action, ExecutionContext context) throws ActionException {
        Log.info((String)("> ShareDevice::Request: lanDeviceId = " + action.getLanDeviceId() + ", email = " + action.getEmail()));
        ShareDeviceResponse response = null;
        try {
            response = this.lanDeviceService.shareLanDevice(action.getLanDeviceId(), action.getEmail());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< ShareDevice::Response: " + response.status.toString()));
        if (response.status != ShareDeviceResponse.ShareDeviceStatus.SUCCESS && response.status != ShareDeviceResponse.ShareDeviceStatus.FAILED_EMAILPROBLEM) {
            ServerValidation.exception((String)("SHARE_DEVICE_STATUS_" + response.status.toString()), (String)"", (Object[])new Object[0]);
        }
        ShareDeviceResult result = new ShareDeviceResult();
        result.setStatus(response.status);
        return result;
    }

    public void rollback(ShareDevice action, ShareDeviceResult result, ExecutionContext context) throws ActionException {
    }

    public Class<ShareDevice> getActionType() {
        return ShareDevice.class;
    }
}

