/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.SendViaGC;
import pl.smartapps.hm.WebViewer.shared.rpc.SendViaGCResult;
import pl.smartapps.restserver.rest.response.GatewayClientResponse;
import pl.smartapps.restserver.service.ext.GatewayClientServiceExt;
import pl.smartapps.restserver.service.ext.InvalidSessionException;

@ActionHandlerBean
public class SendViaGCHandler
implements ActionHandler<SendViaGC, SendViaGCResult> {
    @Autowired
    private GatewayClientServiceExt gatewayClientService;

    public SendViaGCResult execute(SendViaGC action, ExecutionContext context) throws ActionException {
        Log.debug((String)("> SendViaGC::Request: macAddress=" + action.getMacAddress() + ", url=" + action.getUrl() + "."));
        GatewayClientResponse response = null;
        try {
            response = this.gatewayClientService.send(action.getMacAddress(), action.getUrl());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< SendViaGC::Response: " + response.status + ", body=" + response.body));
        if (response.status != GatewayClientResponse.GatewayClientResponseStatus.OK) {
            ServerValidation.exception((String)("SEND_VIA_GC_STATUS_" + response.status.toString()), (String)"", (Object[])new Object[0]);
        }
        SendViaGCResult result = new SendViaGCResult();
        result.setBody(response.body);
        return result;
    }

    public void rollback(SendViaGC action, SendViaGCResult result, ExecutionContext context) throws ActionException {
    }

    public Class<SendViaGC> getActionType() {
        return SendViaGC.class;
    }
}

