/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.SearchCandidates;
import pl.smartapps.hm.WebViewer.shared.rpc.SearchCandidatesResult;
import pl.smartapps.restserver.rest.response.CandidatesResponse;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.VideoStreamServiceExt;

@ActionHandlerBean
public class SearchCandidatesHandler
implements ActionHandler<SearchCandidates, SearchCandidatesResult> {
    @Autowired
    private VideoStreamServiceExt videoStreamService;

    public SearchCandidatesResult execute(SearchCandidates action, ExecutionContext context) throws ActionException {
        Log.debug((String)("> SearchCandidates::Request: " + action.getGcId() + " " + action.getCandidates()));
        CandidatesResponse response = new CandidatesResponse();
        try {
            response = this.videoStreamService.searchCandidates(Integer.valueOf(action.getGcId()), action.getCandidates());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.debug((String)("< SearchCandidates::Response: status=" + response.status.toString() + ", candidates=" + response.candidates));
        if (response.status != CandidatesResponse.CandidatesStatus.OK) {
            ServerValidation.exception((String)("SEARCH_CANDIDATES_" + response.status.toString()), (String)"", (Object[])new Object[0]);
        }
        SearchCandidatesResult result = new SearchCandidatesResult();
        result.setCandidates(response.asCandidates());
        return result;
    }

    public void rollback(SearchCandidates action, SearchCandidatesResult result, ExecutionContext context) throws ActionException {
    }

    public Class<SearchCandidates> getActionType() {
        return SearchCandidates.class;
    }
}

