/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.RunScriptOnGC;
import pl.smartapps.hm.WebViewer.shared.rpc.RunScriptOnGCResult;
import pl.smartapps.restserver.rest.response.GatewayClientResponse;
import pl.smartapps.restserver.service.ext.GatewayClientServiceExt;
import pl.smartapps.restserver.service.ext.InvalidSessionException;

@ActionHandlerBean
public class RunScriptOnGCHandler
implements ActionHandler<RunScriptOnGC, RunScriptOnGCResult> {
    @Autowired
    private GatewayClientServiceExt gatewayClientService;

    public RunScriptOnGCResult execute(RunScriptOnGC action, ExecutionContext context) throws ActionException {
        Log.debug((String)("> RunScriptOnGC::Request: macAddress=" + action.getMacAddress() + ", scriptName=" + action.getScriptName() + "."));
        GatewayClientResponse response = null;
        try {
            response = this.gatewayClientService.runScript(action.getMacAddress(), action.getScriptName());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< RunScriptOnGC::Response: " + response.status + ", body=" + response.body));
        if (response.status != GatewayClientResponse.GatewayClientResponseStatus.OK) {
            ServerValidation.exception((String)("RUN_SCRIPT_ON_GC_STATUS_" + response.status.toString()), (String)"", (Object[])new Object[0]);
        }
        RunScriptOnGCResult result = new RunScriptOnGCResult();
        result.setBody(response.body);
        result.setStatusCode(response.statusCode);
        return result;
    }

    public void rollback(RunScriptOnGC action, RunScriptOnGCResult result, ExecutionContext context) throws ActionException {
    }

    public Class<RunScriptOnGC> getActionType() {
        return RunScriptOnGC.class;
    }
}

