/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.ResendPaymentReceiptStatus;
import pl.smartapps.hm.WebViewer.shared.rpc.ResendPaymentReceipt;
import pl.smartapps.hm.WebViewer.shared.rpc.VoidResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.PaymentServiceExt;

@ActionHandlerBean
public class ResendPaymentReceiptHandler
implements ActionHandler<ResendPaymentReceipt, VoidResult> {
    @Autowired
    private PaymentServiceExt paymentService;

    public VoidResult execute(ResendPaymentReceipt action, ExecutionContext context) throws ActionException {
        ResendPaymentReceiptStatus status = null;
        Log.info((String)"> ResendPaymentReceipt::Request");
        try {
            status = this.paymentService.resendPaymentReceipt(action.getTransactionId(), action.getNotifyOperator().booleanValue());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< ResendPaymentReceipt::Response: " + status));
        if (status != ResendPaymentReceiptStatus.SUCCESS) {
            ServerValidation.exception((String)("RESEND_PAYMENT_RECEIPT_" + status), (String)"", (Object[])new Object[0]);
        }
        return VoidResult.VOID;
    }

    public void rollback(ResendPaymentReceipt action, VoidResult result, ExecutionContext context) throws ActionException {
    }

    public Class<ResendPaymentReceipt> getActionType() {
        return ResendPaymentReceipt.class;
    }
}

