/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.ResendActivationCodeStatus;
import pl.smartapps.hm.WebViewer.shared.rpc.ResendActivationCode;
import pl.smartapps.hm.WebViewer.shared.rpc.VoidResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.UserServiceExt;

@ActionHandlerBean
public class ResendActivationCodeHandler
implements ActionHandler<ResendActivationCode, VoidResult> {
    @Autowired
    private UserServiceExt userService;

    public VoidResult execute(ResendActivationCode action, ExecutionContext context) throws ActionException {
        Log.info((String)("> ResendActivationCode::Request: " + action.getUserId()));
        ResendActivationCodeStatus response = null;
        try {
            response = this.userService.resendActivationCode(action.getUserId());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< ResendActivationCode::Response: " + response));
        if (response != ResendActivationCodeStatus.SUCCESS) {
            ServerValidation.exception((String)("RESEND_ACTIVATION_CODE_STATUS_" + response), (String)"", (Object[])new Object[0]);
        }
        return VoidResult.VOID;
    }

    public void rollback(ResendActivationCode action, VoidResult result, ExecutionContext context) throws ActionException {
    }

    public Class<ResendActivationCode> getActionType() {
        return ResendActivationCode.class;
    }
}

