/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.RecordingControl;
import pl.smartapps.hm.WebViewer.shared.rpc.VoidResult;
import pl.smartapps.restserver.rest.response.RecordingControlResponse;
import pl.smartapps.restserver.service.ext.EventServiceExt;
import pl.smartapps.restserver.service.ext.InvalidSessionException;

@ActionHandlerBean
public class RecordingControlHandler
implements ActionHandler<RecordingControl, VoidResult> {
    @Autowired
    private EventServiceExt eventService;

    public VoidResult execute(RecordingControl action, ExecutionContext context) throws ActionException {
        RecordingControlResponse response;
        Log.info((String)("> RecordingControl::Request: " + action.getLanDeviceId()));
        try {
            response = this.eventService.recordingControl(action.getLanDeviceId(), action.isRecording());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
            return null;
        }
        Log.info((String)("< RecordingControl::Response: " + response.status.toString()));
        if (response.status != RecordingControlResponse.RecordingControlStatus.SUCCESS) {
            if (response.status == RecordingControlResponse.RecordingControlStatus.FAILED_NORECORDING) {
                ServerValidation.exception((String)("RECORDING_CONTROL_STATUS_" + response.status.toString()), (String)"", (Object[])new Object[0]);
            } else {
                ServerValidation.exception((String)"RECORDING_CONTROL_STATUS_ERROR", (String)"", (Object[])new Object[0]);
            }
        }
        return VoidResult.VOID;
    }

    public void rollback(RecordingControl action, VoidResult result, ExecutionContext context) throws ActionException {
    }

    public Class<RecordingControl> getActionType() {
        return RecordingControl.class;
    }
}

