/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.ReconfigurationDeviceStatus;
import pl.smartapps.hm.WebViewer.shared.rpc.ReconfigureDevice;
import pl.smartapps.hm.WebViewer.shared.rpc.ReconfigureDeviceResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class ReconfigureDeviceHandler
implements ActionHandler<ReconfigureDevice, ReconfigureDeviceResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public ReconfigureDeviceResult execute(ReconfigureDevice action, ExecutionContext context) throws ActionException {
        Log.info((String)("> ReconfigureDevice::Request: " + action.getLanDeviceId()));
        ReconfigurationDeviceStatus response = null;
        try {
            response = this.lanDeviceService.reconfigureLanDeviceAsAdmin(action.getLanDeviceId());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< ReconfigureDevice::Response: " + response + "."));
        if (response == ReconfigurationDeviceStatus.ERROR) {
            ServerValidation.exception((String)("RECONFIGURE_DEVICE_STATUS_" + response), (String)"", (Object[])new Object[0]);
        }
        ReconfigureDeviceResult result = new ReconfigureDeviceResult();
        result.setStatus(response);
        return result;
    }

    public void rollback(ReconfigureDevice action, ReconfigureDeviceResult result, ExecutionContext context) throws ActionException {
    }

    public Class<ReconfigureDevice> getActionType() {
        return ReconfigureDevice.class;
    }
}

